/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml.xliff;

import java.awt.Dialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.filters3.xml.XMLFilter;
import org.omegat.filters3.xml.xliff.EditXLIFFOptionsDialog;
import org.omegat.filters3.xml.xliff.XLIFFDialect;
import org.omegat.filters3.xml.xliff.XLIFFOptions;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.xml.sax.Attributes;

public class XLIFFFilter
extends XMLFilter {
    private String resname;
    private boolean ignored;
    private ArrayList<String> groupResname = new ArrayList();
    private int groupLevel;
    private ArrayList<String> notes = new ArrayList();
    private StringBuilder text = new StringBuilder();
    private ArrayList<String> entryText = new ArrayList();
    private ArrayList<List<ProtectedPart>> protectedParts = new ArrayList();
    private HashSet<String> altIDCache = new HashSet();
    private String id;
    private XLIFFOptions.ID_TYPE altTransIDType = XLIFFOptions.ID_TYPE.CONTEXT;

    public static void loadPlugins() {
        Core.registerFilterClass(XLIFFFilter.class);
    }

    public static void unloadPlugins() {
    }

    public XLIFFFilter() {
        super(new XLIFFDialect());
    }

    @Override
    public String getFileFormatName() {
        return OStrings.getString("XLIFF_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.xlf", null, null), new Instance("*.xliff", null, null), new Instance("*.sdlxliff", null, null)};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    protected boolean requirePrevNextFields() {
        return this.altTransIDType == XLIFFOptions.ID_TYPE.CONTEXT;
    }

    @Override
    public boolean hasOptions() {
        return true;
    }

    @Override
    public Map<String, String> changeOptions(Dialog parent, Map<String, String> currentOptions) {
        try {
            EditXLIFFOptionsDialog dialog = new EditXLIFFOptionsDialog(parent, currentOptions);
            dialog.setVisible(true);
            if (1 == dialog.getReturnStatus()) {
                return dialog.getOptions().getOptionsMap();
            }
            return null;
        }
        catch (Exception e) {
            Log.logErrorRB("HTML_EXC_EDIT_OPTIONS", new Object[0]);
            Log.log(e);
            return null;
        }
    }

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        boolean result = super.isFileSupported(inFile, config, context);
        if (result) {
            XLIFFDialect dialect = (XLIFFDialect)this.getDialect();
            dialect.defineDialect(new XLIFFOptions(config));
            try {
                super.processFile(inFile, null, context);
            }
            catch (Exception e) {
                Log.log(e);
            }
            this.altTransIDType = dialect.altTransIDType;
        }
        return result;
    }

    @Override
    public void tagStart(String path, Attributes atts) {
        if (atts != null && path.endsWith("trans-unit")) {
            this.resname = atts.getValue("resname");
            this.id = atts.getValue("id");
        }
        if (path.endsWith("/group")) {
            ++this.groupLevel;
            this.groupResname.add(atts.getValue("resname"));
        }
        if ("/xliff/file/header".equals(path)) {
            this.ignored = true;
        }
        this.text.setLength(0);
    }

    @Override
    public void tagEnd(String path) {
        if (path.endsWith("trans-unit/note")) {
            this.notes.add(this.text.toString());
        } else if (path.endsWith("trans-unit")) {
            if (this.entryParseCallback != null) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.groupLevel; ++i) {
                    String temp = this.groupResname.get(i);
                    if (temp == null) continue;
                    buf.append(temp);
                    buf.append(i == this.groupLevel - 1 ? " : " : " / ");
                }
                if (this.resname != null) {
                    buf.append(this.resname);
                    buf.append('\n');
                }
                for (String note : this.notes) {
                    buf.append(note);
                    buf.append('\n');
                }
                String comment = buf.length() == 0 ? null : buf.substring(0, buf.length() - 1);
                for (int i = 0; i < this.entryText.size(); ++i) {
                    this.entryParseCallback.addEntry(this.getSegID(), this.entryText.get(i), null, false, comment, null, this, this.protectedParts.get(i));
                }
            }
            this.id = null;
            this.resname = null;
            this.notes.clear();
            this.entryText.clear();
            this.protectedParts.clear();
        } else if (path.endsWith("/group")) {
            this.groupResname.remove(--this.groupLevel);
        } else if (path.endsWith("/file")) {
            this.altIDCache.clear();
        }
        if ("/xliff/file/header".equals(path)) {
            this.ignored = false;
        }
    }

    private String getSegID() {
        String segID = null;
        switch (this.altTransIDType) {
            case ELEMENT_ID: {
                segID = this.id;
                break;
            }
            case RESNAME_ATTR: {
                segID = this.resname == null ? this.id : this.resname;
                break;
            }
        }
        if (segID != null) {
            segID = this.ensureUniqueID(segID);
        }
        return segID;
    }

    String ensureUniqueID(String id) {
        int i = 0;
        while (true) {
            String tryID;
            if (!this.altIDCache.contains(tryID = id + (i == 0 ? "" : "_" + i))) {
                this.altIDCache.add(tryID);
                return tryID;
            }
            ++i;
        }
    }

    @Override
    public boolean isInIgnored() {
        return this.ignored;
    }

    @Override
    public void text(String text) {
        this.text.append(text);
    }

    @Override
    public String translate(String entry, List<ProtectedPart> protectedParts) {
        if (this.entryParseCallback != null) {
            if (!StringUtil.isEmpty(entry)) {
                this.entryText.add(entry);
                this.protectedParts.add(protectedParts);
            }
            return entry;
        }
        if (this.entryTranslateCallback != null) {
            String translation = StringUtil.isEmpty(entry) ? entry : this.entryTranslateCallback.getTranslation(this.getSegID(), entry, null);
            return translation != null ? translation : entry;
        }
        return entry;
    }
}

