/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.omegat.gui.common.OmegaTIcons;
import org.omegat.gui.dialogs.LicenseDialog;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class AboutDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JScrollPane aboutpane;
    private JTextArea abouttext;
    private JPanel buttonPanel;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel javaversion;
    private JButton licenseButton;
    private JLabel memoryusage;
    private JButton okButton;
    private JLabel versionLabel;
    private int returnStatus = 0;

    public AboutDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.versionLabel.setText(this.getVersionString());
        Object[] args = new Object[]{Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L, Runtime.getRuntime().maxMemory() / 1024L / 1024L};
        String memoryUsage = StringUtil.format(OStrings.getString("MEMORY_USAGE"), args);
        this.memoryusage.setText(memoryUsage);
        String javaVersion = StringUtil.format(OStrings.getString("JAVA_VERSION"), System.getProperty("java.version"), Platform.is64Bit() ? 64 : 32);
        this.javaversion.setText(javaVersion);
        this.invalidate();
        this.pack();
        StaticUIUtils.fitInScreen(this);
        DockingUI.displayCentered(this);
    }

    private String getVersionString() {
        if (!StringUtil.isEmpty(OStrings.UPDATE) && !OStrings.UPDATE.equals("0")) {
            return StringUtil.format(OStrings.getString("ABOUTDIALOG_VERSION_UPDATE_REVISION"), OStrings.VERSION, OStrings.UPDATE, OStrings.REVISION);
        }
        return StringUtil.format(OStrings.getString("ABOUTDIALOG_VERSION_REVISION"), OStrings.VERSION, OStrings.REVISION);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.licenseButton = new JButton();
        this.okButton = new JButton();
        this.jPanel2 = new JPanel();
        this.javaversion = new JLabel();
        this.memoryusage = new JLabel();
        this.versionLabel = new JLabel();
        this.aboutpane = new JScrollPane();
        this.abouttext = new JTextArea();
        this.setTitle(OStrings.getString("ABOUTDIALOG_TITLE"));
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.jLabel2, OStrings.getString("ABOUTDIALOG_COPYRIGHT"));
        this.jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel.add((Component)this.jLabel2, "West");
        Mnemonics.setLocalizedText(this.licenseButton, OStrings.getString("ABOUTDIALOG_LICENSE_BUTTON"));
        this.licenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.licenseButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.licenseButton);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.okButton);
        this.buttonPanel.add((Component)this.jPanel1, "East");
        this.jPanel2.setLayout(new GridLayout(0, 1));
        Mnemonics.setLocalizedText(this.javaversion, OStrings.getString("JAVA_VERSION"));
        this.jPanel2.add(this.javaversion);
        Mnemonics.setLocalizedText(this.memoryusage, OStrings.getString("MEMORY_USAGE"));
        this.jPanel2.add(this.memoryusage);
        this.buttonPanel.add((Component)this.jPanel2, "North");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.versionLabel.setIcon(new ImageIcon(OmegaTIcons.ICONS.get(1)));
        Mnemonics.setLocalizedText(this.versionLabel, OStrings.getString("ABOUTDIALOG_VERSION_REVISION"));
        this.versionLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.versionLabel, "North");
        this.aboutpane.setHorizontalScrollBarPolicy(31);
        this.aboutpane.setCursor(new Cursor(0));
        this.abouttext.setEditable(false);
        this.abouttext.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.abouttext.setFont(this.versionLabel.getFont());
        this.abouttext.setLineWrap(true);
        this.abouttext.setText(OStrings.getString("ABOUTDIALOG_CONTRIBUTORS"));
        this.abouttext.setWrapStyleWord(true);
        this.abouttext.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.abouttext.setCaretPosition(0);
        this.aboutpane.setViewportView(this.abouttext);
        this.getContentPane().add((Component)this.aboutpane, "Center");
    }

    private void licenseButtonActionPerformed(ActionEvent evt) {
        new LicenseDialog(this).setVisible(true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

