/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.concurrent.CancellationException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.omegat.core.Core;
import org.omegat.core.team.GITRemoteRepository;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.core.team.RepositoryUtils;
import org.omegat.core.team.SVNRemoteRepository;
import org.omegat.gui.dialogs.NewProjectFileChooser;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class NewTeamProject
extends JDialog {
    public Class<? extends IRemoteRepository> repoType = null;
    public IRemoteRepository.Credentials credentials = null;
    private RepoTypeWorker repoTypeWorker = null;
    private boolean detecting = false;
    private JButton btnCancel;
    private JButton btnDirectory;
    private JButton btnOk;
    private JLabel detectedRepoLabel;
    private JPanel jPanel2;
    private JLabel localFolderLabel;
    public JTextField txtDirectory;
    public JTextField txtRepositoryURL;
    private JLabel urlLabel;
    public boolean ok;

    public NewTeamProject(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.txtRepositoryURL.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTeamProject.this.clearRepo();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTeamProject.this.clearRepo();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTeamProject.this.clearRepo();
            }
        });
        this.txtDirectory.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTeamProject.this.updateDialog();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTeamProject.this.updateDialog();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTeamProject.this.updateDialog();
            }
        });
        StaticUIUtils.setEscapeClosable(this);
        this.getRootPane().setDefaultButton(this.btnOk);
        DockingUI.displayCentered(this);
    }

    private void suggestSaveDirectory(String repoName) {
        if (repoName == null || !this.txtDirectory.getText().isEmpty()) {
            return;
        }
        String dir = Preferences.getPreferenceDefault("current_folder", System.getProperty("user.home"));
        File suggestion = new File(dir, repoName);
        int suff = 1;
        while (suggestion.exists()) {
            suggestion = new File(dir, repoName + "-" + suff++);
        }
        this.txtDirectory.setText(suggestion.getAbsolutePath());
    }

    private synchronized void detectRepo() {
        if (this.detecting || !this.isVisible()) {
            return;
        }
        this.txtRepositoryURL.setText(this.txtRepositoryURL.getText().trim());
        String url = this.txtRepositoryURL.getText();
        if (StringUtil.isEmpty(url)) {
            return;
        }
        if (url.startsWith("git!")) {
            this.txtRepositoryURL.setText(url.substring("git!".length()));
            this.detectedRepoLabel.setText(OStrings.getString("TEAM_DETECTED_REPO_GIT"));
            this.repoType = GITRemoteRepository.class;
        } else if (url.startsWith("svn!")) {
            this.txtRepositoryURL.setText(url.substring("svn!".length()));
            this.detectedRepoLabel.setText(OStrings.getString("TEAM_DETECTED_REPO_SVN"));
            this.repoType = SVNRemoteRepository.class;
        } else {
            this.repoTypeWorker = new RepoTypeWorker(url);
            this.repoTypeWorker.execute();
        }
    }

    private synchronized void startDetectingRepo() {
        this.detecting = true;
    }

    private synchronized void stopDetectingRepo() {
        this.detecting = false;
    }

    private void clearRepo() {
        this.repoType = null;
        this.detectedRepoLabel.setText(" ");
        if (this.repoTypeWorker != null) {
            this.repoTypeWorker.cancel(true);
        }
        this.updateDialog();
    }

    private void initComponents() {
        this.urlLabel = new JLabel();
        this.txtRepositoryURL = new JTextField();
        this.detectedRepoLabel = new JLabel();
        this.localFolderLabel = new JLabel();
        this.txtDirectory = new JTextField();
        this.btnDirectory = new JButton();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("TEAM_NEW_HEADER"));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText(this.urlLabel, OStrings.getString("TEAM_NEW_REPOSITORY_URL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.urlLabel, gridBagConstraints);
        this.txtRepositoryURL.setColumns(40);
        this.txtRepositoryURL.setToolTipText("");
        this.txtRepositoryURL.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProject.this.txtRepositoryURLFocusLost(evt);
            }
        });
        this.txtRepositoryURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.txtRepositoryURLActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.txtRepositoryURL, gridBagConstraints);
        Mnemonics.setLocalizedText(this.detectedRepoLabel, " ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.detectedRepoLabel, gridBagConstraints);
        Mnemonics.setLocalizedText(this.localFolderLabel, OStrings.getString("TEAM_NEW_DIRECTORY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.localFolderLabel, gridBagConstraints);
        this.txtDirectory.setToolTipText("");
        this.txtDirectory.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                NewTeamProject.this.txtDirectoryFocusLost(evt);
            }
        });
        this.txtDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.txtDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        this.getContentPane().add((Component)this.txtDirectory, gridBagConstraints);
        Mnemonics.setLocalizedText(this.btnDirectory, "...");
        this.btnDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.btnDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.getContentPane().add((Component)this.btnDirectory, gridBagConstraints);
        Mnemonics.setLocalizedText(this.btnOk, OStrings.getString("BUTTON_OK"));
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.btnOkActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnOk);
        Mnemonics.setLocalizedText(this.btnCancel, OStrings.getString("BUTTON_CANCEL"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewTeamProject.this.btnCancelActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void updateDialog() {
        String repoUrl = this.txtRepositoryURL.getText();
        if (repoUrl.trim().equals(" ")) {
            this.detectedRepoLabel.setText("");
        }
        boolean enabled = this.repoType != null && !StringUtil.isEmpty(repoUrl) && !StringUtil.isEmpty(this.txtDirectory.getText());
        this.btnOk.setEnabled(enabled);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.repoType = null;
        if (this.credentials != null) {
            this.credentials.clear();
            this.credentials = null;
        }
        if (this.repoTypeWorker != null) {
            this.repoTypeWorker.cancel(true);
        }
        this.dispose();
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.dispose();
        this.ok = true;
    }

    private void btnDirectoryActionPerformed(ActionEvent evt) {
        int ndcResult;
        NewProjectFileChooser ndc = new NewProjectFileChooser();
        String saveDir = this.txtDirectory.getText();
        if (!saveDir.isEmpty()) {
            ndc.setSelectedFile(new File(saveDir));
        }
        if ((ndcResult = ndc.showSaveDialog(Core.getMainWindow().getApplicationFrame())) == 0) {
            this.txtDirectory.setText(ndc.getSelectedFile().getPath());
        }
        this.updateDialog();
    }

    private void txtRepositoryURLActionPerformed(ActionEvent evt) {
        this.detectRepo();
    }

    private void txtRepositoryURLFocusLost(FocusEvent evt) {
        this.detectRepo();
    }

    private void txtDirectoryFocusLost(FocusEvent evt) {
        this.updateDialog();
    }

    private void txtDirectoryActionPerformed(ActionEvent evt) {
        this.updateDialog();
    }

    private class RepoTypeWorker
    extends SwingWorker<RepositoryUtils.RepoTypeDetector, Object> {
        private String url = null;

        public RepoTypeWorker(String url) {
            this.url = url;
        }

        @Override
        protected RepositoryUtils.RepoTypeDetector doInBackground() throws Exception {
            NewTeamProject.this.startDetectingRepo();
            NewTeamProject.this.detectedRepoLabel.setText(OStrings.getString("TEAM_DETECTING_REPO"));
            RepositoryUtils.RepoTypeDetector detector = new RepositoryUtils.RepoTypeDetector(this.url, NewTeamProject.this.credentials);
            detector.execute();
            return detector;
        }

        @Override
        protected void done() {
            String resultText = OStrings.getString("TEAM_DETECTED_REPO_UNKNOWN");
            String repoName = null;
            try {
                RepositoryUtils.RepoTypeDetector detector = (RepositoryUtils.RepoTypeDetector)this.get();
                NewTeamProject.this.repoType = detector.repoType;
                NewTeamProject.this.credentials = detector.credentials;
                if (NewTeamProject.this.repoType != null) {
                    if (NewTeamProject.this.repoType.equals(GITRemoteRepository.class)) {
                        resultText = OStrings.getString("TEAM_DETECTED_REPO_GIT");
                        repoName = GITRemoteRepository.guessRepoName(this.url);
                    } else if (NewTeamProject.this.repoType.equals(SVNRemoteRepository.class)) {
                        resultText = OStrings.getString("TEAM_DETECTED_REPO_SVN");
                        repoName = SVNRemoteRepository.guessRepoName(this.url);
                    }
                }
            }
            catch (CancellationException ex) {
                resultText = " ";
            }
            catch (Exception ex) {
                resultText = OStrings.getString("TEAM_ERROR_DETECTING_REPO");
                Log.logErrorRB(ex, "TEAM_ERROR_DETECTING_REPO", new Object[0]);
            }
            NewTeamProject.this.detectedRepoLabel.setText(resultText);
            NewTeamProject.this.suggestSaveDirectory(repoName);
            NewTeamProject.this.updateDialog();
            NewTeamProject.this.stopDetectingRepo();
        }
    }
}

