/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class SaveOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JCheckBox allowProjectCmdCheckBox;
    private JButton cancelButton;
    private JTextArea externalCmdDescriptionTextArea;
    private JLabel externalCommandLabel;
    private JScrollPane externalCommandScrollPane;
    private JTextArea externalCommandTextArea;
    private JButton insertButton;
    private JTextArea intervalDescriptionTextArea;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel minutesLabel;
    private JSpinner minutesSpinner;
    private JButton okButton;
    private JLabel secondsLabel;
    private JSpinner secondsSpinner;
    private JLabel variablesLabel;
    private JComboBox variablesList;
    private int returnStatus = 0;

    public SaveOptionsDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        int saveInterval = Preferences.getPreferenceDefault("auto_save_interval", 180);
        this.minutesSpinner.setValue(saveInterval / 60);
        this.secondsSpinner.setValue(saveInterval % 60);
        this.externalCommandTextArea.setText(Preferences.getPreference("external_command"));
        this.allowProjectCmdCheckBox.setSelected(Preferences.isPreference("allow_project_extern_cmd"));
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.intervalDescriptionTextArea = new JTextArea();
        this.jPanel5 = new JPanel();
        this.jPanel10 = new JPanel();
        this.minutesLabel = new JLabel();
        this.minutesSpinner = new JSpinner();
        this.secondsLabel = new JLabel();
        this.secondsSpinner = new JSpinner();
        this.jPanel2 = new JPanel();
        this.externalCommandLabel = new JLabel();
        this.jPanel8 = new JPanel();
        this.externalCmdDescriptionTextArea = new JTextArea();
        this.externalCommandScrollPane = new JScrollPane();
        this.externalCommandTextArea = new JTextArea();
        this.jPanel4 = new JPanel();
        this.variablesLabel = new JLabel();
        this.variablesList = new JComboBox();
        this.insertButton = new JButton();
        this.allowProjectCmdCheckBox = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jPanel9 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setTitle(OStrings.getString("SAVE_DIALOG_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SaveOptionsDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel1.setLayout(new BorderLayout());
        this.intervalDescriptionTextArea.setEditable(false);
        this.intervalDescriptionTextArea.setFont(new JLabel().getFont());
        this.intervalDescriptionTextArea.setLineWrap(true);
        this.intervalDescriptionTextArea.setText(OStrings.getString("SAVE_DIALOG_DESCRIPTION"));
        this.intervalDescriptionTextArea.setWrapStyleWord(true);
        this.intervalDescriptionTextArea.setOpaque(false);
        this.jPanel1.add((Component)this.intervalDescriptionTextArea, "North");
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 20, 0, 0));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel10.setLayout(new GridBagLayout());
        this.minutesLabel.setLabelFor(this.minutesSpinner);
        Mnemonics.setLocalizedText(this.minutesLabel, OStrings.getString("SAVE_DIALOG_MINUTES"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel10.add((Component)this.minutesLabel, gridBagConstraints);
        this.minutesSpinner.setValue(90);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        this.jPanel10.add((Component)this.minutesSpinner, gridBagConstraints);
        this.secondsLabel.setLabelFor(this.secondsSpinner);
        Mnemonics.setLocalizedText(this.secondsLabel, OStrings.getString("SAVE_DIALOG_SECONDS"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel10.add((Component)this.secondsLabel, gridBagConstraints);
        this.secondsSpinner.setValue(90);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 50;
        this.jPanel10.add((Component)this.secondsSpinner, gridBagConstraints);
        this.jPanel5.add((Component)this.jPanel10, "West");
        this.jPanel1.add((Component)this.jPanel5, "Center");
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.externalCommandLabel.setLabelFor(this.externalCommandTextArea);
        Mnemonics.setLocalizedText(this.externalCommandLabel, OStrings.getString("EXTERNAL_COMMAND_LABEL"));
        this.jPanel2.add((Component)this.externalCommandLabel, "North");
        this.jPanel8.setLayout(new BorderLayout());
        this.externalCmdDescriptionTextArea.setEditable(false);
        this.externalCmdDescriptionTextArea.setFont(new JLabel().getFont());
        this.externalCmdDescriptionTextArea.setLineWrap(true);
        this.externalCmdDescriptionTextArea.setText(OStrings.getString("EXTERNAL_COMMAND_DESCRIPTION"));
        this.externalCmdDescriptionTextArea.setWrapStyleWord(true);
        this.externalCmdDescriptionTextArea.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
        this.externalCmdDescriptionTextArea.setOpaque(false);
        this.jPanel8.add((Component)this.externalCmdDescriptionTextArea, "North");
        this.externalCommandTextArea.setColumns(20);
        this.externalCommandTextArea.setLineWrap(true);
        this.externalCommandTextArea.setRows(5);
        this.externalCommandScrollPane.setViewportView(this.externalCommandTextArea);
        this.jPanel8.add((Component)this.externalCommandScrollPane, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.variablesLabel, OStrings.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
        this.jPanel4.add((Component)this.variablesLabel, "West");
        this.variablesList.setModel(new DefaultComboBoxModel<String>(CommandVarExpansion.COMMAND_VARIABLES));
        this.jPanel4.add((Component)this.variablesList, "Center");
        Mnemonics.setLocalizedText(this.insertButton, OStrings.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveOptionsDialog.this.insertButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.insertButton, "East");
        this.jPanel8.add((Component)this.jPanel4, "South");
        this.jPanel2.add((Component)this.jPanel8, "Center");
        this.allowProjectCmdCheckBox.setFont(new JLabel().getFont());
        Mnemonics.setLocalizedText(this.allowProjectCmdCheckBox, OStrings.getString("ALLOW_PROJECT_EXTERN_CMD"));
        this.jPanel2.add((Component)this.allowProjectCmdCheckBox, "South");
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel9.setLayout(new BoxLayout(this.jPanel9, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SaveOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel9.add(this.cancelButton);
        this.jPanel3.add((Component)this.jPanel9, "East");
        this.getContentPane().add((Component)this.jPanel3, "South");
        this.pack();
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.externalCommandTextArea.replaceSelection(this.variablesList.getSelectedItem().toString());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int saveMinutes = 0;
        int saveSeconds = 0;
        try {
            saveMinutes = Integer.parseInt(this.minutesSpinner.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            saveSeconds = Integer.parseInt(this.secondsSpinner.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int saveInterval = saveMinutes * 60 + saveSeconds;
        if (saveInterval < 10) {
            saveInterval = 10;
        }
        Preferences.setPreference("auto_save_interval", saveInterval);
        Preferences.setPreference("external_command", this.externalCommandTextArea.getText());
        Preferences.setPreference("allow_project_extern_cmd", this.allowProjectCmdCheckBox.isSelected());
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

