/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegat.core.spellchecker.DictionaryManager;
import org.omegat.gui.dialogs.DictionaryInstallerDialog;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class SpellcheckerConfigurationDialog
extends JDialog {
    private final JFileChooser fileChooser = new JFileChooser();
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private final Language currentLanguage;
    private DictionaryManager dicMan;
    private final DefaultListModel languageListModel;
    private JCheckBox autoSpellcheckCheckBox;
    private JButton cancelButton;
    private JLabel contentLabel;
    private JPanel detailPanel;
    private JLabel dictionaryUrlLabel;
    private JTextField dictionaryUrlTextField;
    private JButton directoryChooserButton;
    private JLabel directoryLabel;
    private JTextField directoryTextField;
    private JButton installButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JList languageList;
    private JScrollPane languageScrollPane;
    private JButton okButton;
    private JButton uninstallButton;

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public SpellcheckerConfigurationDialog(Frame parent, Language current) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.currentLanguage = current;
        this.languageListModel = new DefaultListModel();
        this.autoSpellcheckCheckBox.setSelected(Preferences.isPreference("allow_auto_spellchecking"));
        this.updateDetailPanel();
        this.directoryTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpellcheckerConfigurationDialog.this.updateDirectory();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpellcheckerConfigurationDialog.this.updateDirectory();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SpellcheckerConfigurationDialog.this.updateDirectory();
            }
        });
        this.directoryTextField.setText(Preferences.getPreference("spellcheker_dir"));
        this.dictionaryUrlTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpellcheckerConfigurationDialog.this.updateDictUrl();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpellcheckerConfigurationDialog.this.updateDictUrl();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SpellcheckerConfigurationDialog.this.updateDictUrl();
            }
        });
        String dictionaryUrl = Preferences.getPreference("dictionary_url");
        if (dictionaryUrl.isEmpty() || "http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries/".equalsIgnoreCase(dictionaryUrl)) {
            this.dictionaryUrlTextField.setText("http://download.services.openoffice.org/files/contrib/dictionaries/");
        } else {
            this.dictionaryUrlTextField.setText(Preferences.getPreference("dictionary_url"));
        }
        DockingUI.displayCentered(this);
        this.updateDirectory();
        this.languageListValueChanged(null);
    }

    private File getDictDir() {
        String dirName = this.directoryTextField.getText();
        if (StringUtil.isEmpty(dirName)) {
            return null;
        }
        File dir = new File(dirName);
        if (dir.isFile() || dir.exists() && !dir.canRead()) {
            return null;
        }
        return dir;
    }

    private void updateDirectory() {
        this.updateDictUrl();
        this.updateLanguageList();
    }

    public final void updateLanguageList() {
        this.languageListModel.clear();
        File dir = this.getDictDir();
        if (dir == null) {
            return;
        }
        this.dicMan = new DictionaryManager(dir);
        List<String> aList = this.dicMan.getLocalDictionaryNameList();
        Collections.sort(aList);
        for (String str : aList) {
            this.languageListModel.addElement(str);
        }
        this.languageList.setModel(this.languageListModel);
    }

    private void updateDetailPanel() {
        boolean enabled = this.autoSpellcheckCheckBox.isSelected();
        this.contentLabel.setEnabled(enabled);
        this.directoryChooserButton.setEnabled(enabled);
        this.directoryLabel.setEnabled(enabled);
        this.directoryTextField.setEnabled(enabled);
        this.languageScrollPane.setEnabled(enabled);
        this.languageList.setEnabled(enabled);
        this.updateDirectory();
    }

    private void updateDictUrl() {
        File dictDir = this.getDictDir();
        this.installButton.setEnabled(this.autoSpellcheckCheckBox.isSelected() && dictDir != null && dictDir.canWrite() && !this.dictionaryUrlTextField.getText().isEmpty());
    }

    private void initComponents() {
        this.autoSpellcheckCheckBox = new JCheckBox();
        this.detailPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.directoryLabel = new JLabel();
        this.directoryTextField = new JTextField();
        this.jPanel8 = new JPanel();
        this.directoryChooserButton = new JButton();
        this.jPanel3 = new JPanel();
        this.contentLabel = new JLabel();
        this.languageScrollPane = new JScrollPane();
        this.languageList = new JList();
        this.jPanel4 = new JPanel();
        this.uninstallButton = new JButton();
        this.jPanel5 = new JPanel();
        this.dictionaryUrlLabel = new JLabel();
        this.dictionaryUrlTextField = new JTextField();
        this.jPanel6 = new JPanel();
        this.installButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel7 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("GUI_SPELLCHECKER_TITLE"));
        this.setPreferredSize(new Dimension(600, 500));
        Mnemonics.setLocalizedText(this.autoSpellcheckCheckBox, OStrings.getString("GUI_SPELLCHECKER_AUTOSPELLCHECKCHECKBOX"));
        this.autoSpellcheckCheckBox.setBorder(BorderFactory.createEmptyBorder(20, 20, 5, 0));
        this.autoSpellcheckCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.autoSpellcheckCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.autoSpellcheckCheckBoxActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.autoSpellcheckCheckBox, "North");
        this.detailPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20), BorderFactory.createEtchedBorder()));
        this.detailPanel.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        this.jPanel1.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.directoryLabel, OStrings.getString("GUI_SPELLCHECKER_DICTIONARYLABEL"));
        this.jPanel1.add((Component)this.directoryLabel, "North");
        this.directoryTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.directoryTextFieldActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.directoryTextField, "Center");
        this.jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel8.setLayout(new BoxLayout(this.jPanel8, 2));
        Mnemonics.setLocalizedText(this.directoryChooserButton, OStrings.getString("GUI_SPELLCHECKER_DIRECTORYCHOOSERBUTTON"));
        this.directoryChooserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.directoryChooserButtonActionPerformed(evt);
            }
        });
        this.jPanel8.add(this.directoryChooserButton);
        this.jPanel1.add((Component)this.jPanel8, "East");
        this.detailPanel.add((Component)this.jPanel1, "North");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.jPanel3.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.contentLabel, OStrings.getString("GUI_SPELLCHECKER_AVAILABLE_LABEL"));
        this.jPanel3.add((Component)this.contentLabel, "North");
        this.languageList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                SpellcheckerConfigurationDialog.this.languageListValueChanged(evt);
            }
        });
        this.languageScrollPane.setViewportView(this.languageList);
        this.jPanel3.add((Component)this.languageScrollPane, "Center");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jPanel4.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.uninstallButton, OStrings.getString("GUI_SPELLCHECKER_UNINSTALLBUTTON"));
        this.uninstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.uninstallButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.uninstallButton, "North");
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.detailPanel.add((Component)this.jPanel3, "Center");
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.jPanel5.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.dictionaryUrlLabel, OStrings.getString("GUI_SPELLCHECKER_URL_LABEL"));
        this.jPanel5.add((Component)this.dictionaryUrlLabel, "North");
        this.jPanel5.add((Component)this.dictionaryUrlTextField, "Center");
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.jPanel6.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.installButton, OStrings.getString("GUI_SPELLCHECKER_INSTALLBUTTON"));
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.installButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add((Component)this.installButton, "West");
        this.jPanel5.add((Component)this.jPanel6, "South");
        this.detailPanel.add((Component)this.jPanel5, "South");
        this.getContentPane().add((Component)this.detailPanel, "Center");
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 1, 20, 20));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SpellcheckerConfigurationDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel7.add(this.cancelButton);
        this.jPanel2.add((Component)this.jPanel7, "East");
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.pack();
    }

    private void languageListValueChanged(ListSelectionEvent evt) {
        Object[] selection = this.languageList.getSelectedValues();
        this.uninstallButton.setEnabled(selection.length > 0 && this.autoSpellcheckCheckBox.isSelected());
    }

    private void directoryTextFieldActionPerformed(ActionEvent evt) {
        this.updateLanguageList();
    }

    private void directoryChooserButtonActionPerformed(ActionEvent evt) {
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle(OStrings.getString("GUI_SPELLCHECKER_FILE_CHOOSER_TITLE"));
        int result = this.fileChooser.showOpenDialog(this);
        if (result == 0) {
            File file = this.fileChooser.getSelectedFile();
            this.directoryTextField.setText(file.getAbsolutePath());
        }
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        File dicDir = this.getDictDir();
        if (dicDir == null) {
            JOptionPane.showMessageDialog(this, OStrings.getString("GUI_SPELLCHECKER_INSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_INSTALL_UNABLE_TITLE"), 0);
            return;
        }
        if (!dicDir.exists()) {
            int doCreateDir = JOptionPane.showConfirmDialog(this, OStrings.getString("GUI_SPELLCHECKER_DIR_NOT_PRESENT"), OStrings.getString("GUI_SPELLCHECKER_DIR_NOT_PRESENT_TITLE"), 2);
            if (doCreateDir != 0) {
                return;
            }
            if (!dicDir.mkdirs()) {
                JOptionPane.showMessageDialog(this, OStrings.getString("GUI_SPELLCHECKER_COULD_NOT_CREATE_DIR"), OStrings.getString("ERROR_TITLE"), 0);
                return;
            }
        }
        Preferences.setPreference("dictionary_url", this.dictionaryUrlTextField.getText());
        try {
            DictionaryInstallerDialog installerDialog = new DictionaryInstallerDialog(this, this.dicMan);
            installerDialog.setVisible(true);
            this.updateLanguageList();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        if (this.dicMan == null) {
            return;
        }
        if (this.currentLanguage != null) {
            Object[] selection;
            for (Object item : selection = this.languageList.getSelectedValues()) {
                String selectedItem = (String)item;
                String selectedLocaleName = selectedItem.substring(0, selectedItem.indexOf(" "));
                if (selectedLocaleName.equals(this.currentLanguage.getLocaleCode()) && JOptionPane.showConfirmDialog(this, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_CURRENT_TITLE"), 0) == 1) {
                    return;
                }
                if (!this.dicMan.uninstallDictionary(selectedLocaleName)) {
                    JOptionPane.showMessageDialog(this, OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE"), OStrings.getString("GUI_SPELLCHECKER_UNINSTALL_UNABLE_TITLE"), 0);
                }
                this.languageListModel.remove(this.languageList.getSelectedIndex());
            }
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("allow_auto_spellchecking", this.autoSpellcheckCheckBox.isSelected());
        Preferences.setPreference("spellcheker_dir", this.directoryTextField.getText());
        Preferences.setPreference("dictionary_url", this.dictionaryUrlTextField.getText());
        this.doClose(1);
    }

    private void autoSpellcheckCheckBoxActionPerformed(ActionEvent evt) {
        this.updateDetailPanel();
    }
}

