/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.omegat.core.data.TMXEntry;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.VarExpansion;

public class ModificationInfoManager {
    public static final String VAR_CREATION_ID = "${creationId}";
    public static final String VAR_CREATION_DATE = "${creationDate}";
    public static final String VAR_CREATION_DATE_COUNTRY = "${creationDateCountry}";
    public static final String VAR_CREATION_DATE_SHORT = "${creationDateShort}";
    public static final String VAR_CREATION_DATE_SHORT_COUNTRY = "${creationDateShortCountry}";
    public static final String VAR_CREATION_TIME = "${creationTime}";
    public static final String VAR_CREATION_TIME_COUNTRY = "${creationTimeCountry}";
    public static final String VAR_CREATION_TIME_SHORT = "${creationTimeShort}";
    public static final String VAR_CREATION_TIME_SHORT_COUNTRY = "${creationTimeShortCountry}";
    public static final String VAR_CHANGED_ID = "${changedId}";
    public static final String VAR_CHANGED_DATE = "${changedDate}";
    public static final String VAR_CHANGED_DATE_COUNTRY = "${changedDateCountry}";
    public static final String VAR_CHANGED_DATE_SHORT = "${changedDateShort}";
    public static final String VAR_CHANGED_DATE_SHORT_COUNTRY = "${changedDateShortCountry}";
    public static final String VAR_CHANGED_TIME = "${changedTime}";
    public static final String VAR_CHANGED_TIME_COUNTRY = "${changedTimeCountry}";
    public static final String VAR_CHANGED_TIME_SHORT = "${changedTimeShort}";
    public static final String VAR_CHANGED_TIME_SHORT_COUNTRY = "${changedTimeShortCountry}";
    public static final String[] MOD_INFO_VARIABLES;
    public static final String[] MOD_INFO_VARIABLES_NO_DATE;
    public static final String DEFAULT_TEMPLATE = "${creationId} - ${changedId} ${changedDate} ${changedTime}";
    public static final String DEFAULT_TEMPLATE_NO_DATE = "${creationId} - ${changedId}";
    private static final DateFormat dateFormat;
    private static final DateFormat dateFormatCountry;
    private static final DateFormat dateFormatShort;
    private static final DateFormat dateFormatShortCountry;
    private static final DateFormat timeFormat;
    private static final DateFormat timeFormatCountry;
    private static final DateFormat timeFormatShort;
    private static final DateFormat timeFormatShortCountry;
    private static ModificationInfoVarExpansion defaultTemplate;
    private static ModificationInfoVarExpansion defaultTemplateND;

    public static void reset() {
        defaultTemplate = new ModificationInfoVarExpansion(Preferences.getPreferenceDefault("view_option_mod_info_template", DEFAULT_TEMPLATE));
        defaultTemplateND = new ModificationInfoVarExpansion(Preferences.getPreferenceDefault("view_option_mod_info_template_wo_date", DEFAULT_TEMPLATE_NO_DATE));
    }

    public static String apply(TMXEntry trans) {
        if (trans.changeDate == 0L) {
            return defaultTemplateND.apply(trans);
        }
        return defaultTemplate.apply(trans);
    }

    static {
        Locale[] locales;
        MOD_INFO_VARIABLES = new String[]{VAR_CREATION_ID, VAR_CREATION_DATE, VAR_CREATION_DATE_COUNTRY, VAR_CREATION_DATE_SHORT, VAR_CREATION_DATE_SHORT_COUNTRY, VAR_CREATION_TIME, VAR_CREATION_TIME_COUNTRY, VAR_CREATION_TIME_SHORT, VAR_CREATION_TIME_SHORT_COUNTRY, VAR_CHANGED_ID, VAR_CHANGED_DATE, VAR_CHANGED_DATE_COUNTRY, VAR_CHANGED_DATE_SHORT, VAR_CHANGED_DATE_SHORT_COUNTRY, VAR_CHANGED_TIME, VAR_CHANGED_TIME_COUNTRY, VAR_CHANGED_TIME_SHORT, VAR_CHANGED_TIME_SHORT_COUNTRY};
        MOD_INFO_VARIABLES_NO_DATE = new String[]{VAR_CREATION_ID, VAR_CHANGED_ID};
        ModificationInfoManager.reset();
        Locale defaultLocale = Locale.getDefault();
        dateFormat = DateFormat.getDateInstance(2, defaultLocale);
        dateFormatShort = DateFormat.getDateInstance(3, defaultLocale);
        timeFormat = DateFormat.getTimeInstance(2, defaultLocale);
        timeFormatShort = DateFormat.getTimeInstance(3, defaultLocale);
        for (Locale l : locales = Locale.getAvailableLocales()) {
            if (!l.getCountry().equals(defaultLocale.getCountry())) continue;
            defaultLocale = l;
            break;
        }
        dateFormatCountry = DateFormat.getDateInstance(2, defaultLocale);
        dateFormatShortCountry = DateFormat.getDateInstance(3, defaultLocale);
        timeFormatCountry = DateFormat.getTimeInstance(2, defaultLocale);
        timeFormatShortCountry = DateFormat.getTimeInstance(3, defaultLocale);
    }

    public static class ModificationInfoVarExpansion
    extends VarExpansion<TMXEntry> {
        public ModificationInfoVarExpansion(String template) {
            super(template);
        }

        @Override
        public String expandVariables(TMXEntry trans) {
            Date creationDate = new Date(trans.creationDate);
            Date changeDate = new Date(trans.changeDate);
            String localTemplate = this.template;
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_ID, trans.creator == null ? OStrings.getString("TF_CUR_SEGMENT_UNKNOWN_AUTHOR") : trans.creator);
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_DATE, trans.creationDate == 0L ? "" : dateFormat.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_DATE_COUNTRY, trans.creationDate == 0L ? "" : dateFormatCountry.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_DATE_SHORT, trans.creationDate == 0L ? "" : dateFormatShort.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_DATE_SHORT_COUNTRY, trans.creationDate == 0L ? "" : dateFormatShortCountry.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_TIME, trans.creationDate == 0L ? "" : timeFormat.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_TIME_COUNTRY, trans.creationDate == 0L ? "" : timeFormatCountry.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_TIME_SHORT, trans.creationDate == 0L ? "" : timeFormatShort.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CREATION_TIME_SHORT_COUNTRY, trans.creationDate == 0L ? "" : timeFormatShortCountry.format(creationDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_ID, trans.changer == null ? OStrings.getString("TF_CUR_SEGMENT_UNKNOWN_AUTHOR") : trans.changer);
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_DATE, trans.changeDate == 0L ? "" : dateFormat.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_DATE_COUNTRY, trans.changeDate == 0L ? "" : dateFormatCountry.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_DATE_SHORT, trans.changeDate == 0L ? "" : dateFormatShort.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_DATE_SHORT_COUNTRY, trans.changeDate == 0L ? "" : dateFormatShortCountry.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_TIME, trans.changeDate == 0L ? "" : timeFormat.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_TIME_COUNTRY, trans.changeDate == 0L ? "" : timeFormatCountry.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_TIME_SHORT, trans.changeDate == 0L ? "" : timeFormatShort.format(changeDate));
            localTemplate = localTemplate.replace(ModificationInfoManager.VAR_CHANGED_TIME_SHORT_COUNTRY, trans.changeDate == 0L ? "" : timeFormatShortCountry.format(changeDate));
            return localTemplate;
        }

        public String apply(TMXEntry trans) {
            return this.expandVariables(trans);
        }
    }
}

