/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autocompleter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.TagAutoCompleterView;
import org.omegat.gui.editor.autocompleter.AbstractAutoCompleterView;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.gui.editor.autocompleter.IAutoCompleter;
import org.omegat.gui.editor.autotext.AutotextAutoCompleterView;
import org.omegat.gui.editor.chartable.CharTableAutoCompleterView;
import org.omegat.gui.glossary.GlossaryAutoCompleterView;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Platform;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class AutoCompleter
implements IAutoCompleter {
    private static final boolean ON_MAC = Platform.isMacOSX();
    private static final int TRIGGER_KEY = ON_MAC ? 27 : 32;
    private static final int TRIGGER_KEY_MASK = ON_MAC ? 0 : Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int GO_NEXT_KEY = ON_MAC ? 39 : 32;
    private static final int GO_NEXT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final int GO_PREV_KEY = ON_MAC ? 37 : 32;
    private static final int GO_PREV_MASK = ON_MAC ? GO_NEXT_MASK : GO_NEXT_MASK | 1;
    private static final int MIN_VIEWPORT_HEIGHT = 50;
    private static final int MAX_POPUP_WIDTH = 500;
    JPopupMenu popup = new JPopupMenu();
    private EditorTextArea3 editor;
    public static final int PAGE_ROW_COUNT = 10;
    private boolean didPopUpAutomatically = false;
    List<AbstractAutoCompleterView> views = new ArrayList<AbstractAutoCompleterView>();
    int currentView = -1;
    JScrollPane scroll;
    JLabel viewLabel;

    public AutoCompleter(EditorTextArea3 editor) {
        this.editor = editor;
        this.scroll = new JScrollPane();
        this.scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scroll.setPreferredSize(new Dimension(200, 200));
        this.scroll.setColumnHeaderView(null);
        this.scroll.setFocusable(false);
        this.scroll.getVerticalScrollBar().setFocusable(false);
        this.scroll.getHorizontalScrollBar().setFocusable(false);
        this.addView(new GlossaryAutoCompleterView());
        this.addView(new AutotextAutoCompleterView());
        this.addView(new TagAutoCompleterView());
        this.addView(new CharTableAutoCompleterView());
        this.viewLabel = new JLabel();
        this.viewLabel.setBorder(new CompoundBorder(new MatteBorder(1, 0, 0, 0, UIManager.getColor("OmegaTBorder.color")), new EmptyBorder(5, 5, 5, 5)));
        this.viewLabel.setOpaque(true);
        this.popup.setBorder(new MatteBorder(1, 1, 1, 1, UIManager.getColor("OmegaTBorder.color")));
        this.popup.setLayout(new BorderLayout());
        this.popup.add((Component)this.scroll, "Center");
        this.popup.add((Component)this.viewLabel, "South");
        this.selectNextView();
    }

    @Override
    public void addView(AbstractAutoCompleterView view) {
        view.setParent(this);
        this.views.add(view);
    }

    public EditorTextArea3 getEditor() {
        return this.editor;
    }

    public boolean processKeys(KeyEvent e) {
        if (!this.isVisible() && StaticUtils.isKey(e, TRIGGER_KEY, TRIGGER_KEY_MASK)) {
            if (!this.editor.isInActiveTranslation(this.editor.getCaretPosition())) {
                return false;
            }
            this.updatePopup();
            this.setVisible(true);
            return true;
        }
        if (this.isVisible()) {
            if (this.getCurrentView().processKeys(e)) {
                return true;
            }
            if (StaticUtils.isKey(e, 10, 0)) {
                this.doSelection();
                return true;
            }
            if (StaticUtils.isKey(e, 155, 0)) {
                this.acceptedListItem(this.getSelectedValue());
                this.updatePopup();
                return true;
            }
            if (StaticUtils.isKey(e, 27, 0)) {
                this.setVisible(false);
                return true;
            }
            if (StaticUtils.isKey(e, GO_PREV_KEY, GO_PREV_MASK)) {
                this.selectPreviousView();
                return true;
            }
            if (StaticUtils.isKey(e, GO_NEXT_KEY, GO_NEXT_MASK)) {
                this.selectNextView();
                return true;
            }
        }
        return false;
    }

    public void doSelection() {
        this.acceptedListItem(this.getSelectedValue());
        if (this.getCurrentView().shouldCloseOnSelection()) {
            this.setVisible(false);
        }
    }

    private AutoCompleterItem getSelectedValue() {
        return this.views.get(this.currentView).getSelectedValue();
    }

    public void updatePopup() {
        AbstractAutoCompleterView view = this.getCurrentView();
        if (this.editor.isEnabled() && view.updateViewData()) {
            this.scroll.setPreferredSize(new Dimension(Math.min(view.getPreferredWidth(), 500), Math.max(view.getPreferredHeight(), 50)));
            this.popup.validate();
            this.popup.pack();
            if (this.isVisible()) {
                Point p = this.getDisplayPoint();
                this.popup.show(this.editor, p.x, p.y);
            }
        }
    }

    private Point getDisplayPoint() {
        int x = 0;
        int y = this.editor.getHeight();
        int fontSize = this.editor.getFont().getSize();
        try {
            int pos = Math.min(this.editor.getCaret().getDot(), this.editor.getCaret().getMark());
            x = this.editor.getUI().modelToView((JTextComponent)this.editor, (int)pos).x;
            y = this.editor.getUI().modelToView((JTextComponent)this.editor, (int)this.editor.getCaret().getDot()).y + fontSize;
        }
        catch (BadLocationException e) {
            Log.log(e);
        }
        return new Point(x, y);
    }

    protected void acceptedListItem(AutoCompleterItem selected) {
        if (selected == null) {
            return;
        }
        int offset = this.editor.getCaretPosition();
        String selection = this.editor.getSelectedText();
        if (StringUtil.isEmpty(selection)) {
            this.editor.setSelectionStart(offset - selected.replacementLength);
            this.editor.setSelectionEnd(offset);
        }
        this.editor.replaceSelection(selected.payload);
        if (selected.cursorAdjust != 0) {
            this.editor.getCaret().setDot(this.editor.getCaretPosition() + selected.cursorAdjust);
        }
        if (selected.keepSelection) {
            this.editor.replaceSelection(selection);
        }
    }

    private int nextViewNumber() {
        return (this.currentView + 1) % this.views.size();
    }

    private int prevViewNumber() {
        return (this.currentView + this.views.size() - 1) % this.views.size();
    }

    private void updateViewLabel() {
        StringBuilder sb = new StringBuilder("<html>");
        sb.append("<b>");
        sb.append(this.getCurrentView().getName());
        sb.append("</b>");
        if (this.views.size() != 1) {
            String nextKeyString = this.keyText(GO_NEXT_KEY, GO_NEXT_MASK);
            String prevKeyString = this.keyText(GO_PREV_KEY, GO_PREV_MASK);
            if (this.views.size() >= 2) {
                sb.append("<br>");
                sb.append(StringUtil.format(OStrings.getString("AC_NEXT_VIEW"), nextKeyString, this.views.get(this.nextViewNumber()).getName()));
            }
            if (this.views.size() > 2) {
                sb.append("<br>");
                sb.append(StringUtil.format(OStrings.getString("AC_PREV_VIEW"), prevKeyString, this.views.get(this.prevViewNumber()).getName()));
            }
        }
        sb.append("</html>");
        this.viewLabel.setText(sb.toString());
    }

    public AbstractAutoCompleterView getCurrentView() {
        return this.views.get(this.currentView);
    }

    private void selectNextView() {
        this.currentView = this.nextViewNumber();
        this.activateView();
    }

    private void activateView() {
        this.scroll.setViewportView(this.getCurrentView().getViewContent());
        this.updateViewLabel();
        if (Core.getProject().isProjectLoaded()) {
            this.updatePopup();
        }
    }

    private void selectPreviousView() {
        this.currentView = this.prevViewNumber();
        this.activateView();
    }

    public boolean isVisible() {
        return this.popup.isVisible();
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Point p = AutoCompleter.this.getDisplayPoint();
                    AutoCompleter.this.popup.show(AutoCompleter.this.editor, p.x, p.y);
                    AutoCompleter.this.editor.requestFocus();
                }
            });
        } else {
            this.popup.setVisible(false);
            this.didPopUpAutomatically = false;
        }
    }

    public String keyText(int base, int modifier) {
        return KeyEvent.getKeyModifiersText(modifier) + "+" + KeyEvent.getKeyText(base);
    }

    public void textDidChange() {
        if (this.isVisible() && !this.didPopUpAutomatically) {
            this.updatePopup();
            return;
        }
        if (!Preferences.isPreference("ac_show_suggestions_automatically")) {
            return;
        }
        int i = this.currentView;
        do {
            if (!this.views.get(i).shouldPopUp()) continue;
            this.currentView = i;
            this.didPopUpAutomatically = true;
            this.activateView();
            this.setVisible(true);
            return;
        } while ((i = (i + 1) % this.views.size()) != this.currentView);
        this.setVisible(false);
    }
}

