/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.TransTips;
import org.omegat.util.Preferences;
import org.omegat.util.gui.Styles;

public class TransTipsMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter transTipsUnderliner = new UnderlineFactory.SolidBoldUnderliner(Styles.EditorColor.COLOR_TRANSTIPS.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) {
        if (!isActive) {
            return null;
        }
        if (!Preferences.isPreference("transtips")) {
            return null;
        }
        List<GlossaryEntry> glossaryEntries = Core.getGlossary().getDisplayedEntries();
        if (glossaryEntries == null || glossaryEntries.isEmpty()) {
            return null;
        }
        final ArrayList<Mark> marks = new ArrayList<Mark>();
        TransTips.Search callback = new TransTips.Search(){

            @Override
            public void found(GlossaryEntry ge, int start, int end) {
                Mark m = new Mark(Mark.ENTRY_PART.SOURCE, start, end);
                m.painter = transTipsUnderliner;
                marks.add(m);
            }
        };
        for (GlossaryEntry ent : glossaryEntries) {
            TransTips.search(sourceText, ent, callback);
        }
        return marks;
    }
}

