/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.MatchResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.omegat.util.LinebreakPreservingReader;

public class ScriptItem
implements Comparable<ScriptItem> {
    private static final String PROPERTIES = "properties/";
    private final String BOM = "\ufeff";
    private boolean startsWithBOM = false;
    private String lineBreak = System.getProperty("line.separator");
    private File m_file = null;
    private String m_scriptName = null;
    private String m_description = null;
    private ResourceBundle m_res = null;

    public ScriptItem(File scriptFile) {
        this.m_file = scriptFile;
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{scriptFile.getParentFile().toURI().toURL()});
            String shortName = FilenameUtils.removeExtension(scriptFile.getName());
            try {
                this.m_res = ResourceBundle.getBundle(shortName, Locale.getDefault(), loader);
            }
            catch (MissingResourceException e) {
                try {
                    this.m_res = ResourceBundle.getBundle(PROPERTIES + shortName, Locale.getDefault(), loader);
                }
                catch (MissingResourceException ex) {
                    this.scanFileForDescription(scriptFile);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFileForDescription(File file) {
        Scanner scan = null;
        try {
            scan = new Scanner(file);
            scan.findInLine(":name\\s*=\\s*(.*)\\s+:description\\s*=\\s*(.*)");
            MatchResult results = scan.match();
            this.m_scriptName = results.group(1).trim();
            this.m_description = results.group(2).trim();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (scan != null) {
                scan.close();
            }
        }
    }

    public ResourceBundle getResourceBundle() {
        if (this.m_res != null) {
            return this.m_res;
        }
        return new ResourceBundle(){
            final String MISSING_BUNDLE_MESSAGE = "ResourceBundle (.properties file for localization) is missing.";

            @Override
            protected Object handleGetObject(String key) {
                throw new MissingResourceException("ResourceBundle (.properties file for localization) is missing.", null, key);
            }

            @Override
            public Enumeration<String> getKeys() {
                throw new MissingResourceException("ResourceBundle (.properties file for localization) is missing.", null, null);
            }
        };
    }

    public String getScriptName() {
        if (this.m_scriptName == null) {
            String name = this.m_file.getName();
            if (this.m_res != null) {
                try {
                    name = this.m_res.getString("name");
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            this.m_scriptName = name;
        }
        return this.m_scriptName;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getDescription() {
        if (this.m_description != null) {
            return this.m_description;
        }
        try {
            this.m_description = this.m_res == null ? "" : this.m_res.getString("description");
        }
        catch (MissingResourceException e) {
            this.m_description = "";
        }
        return this.m_description;
    }

    public String getToolTip() {
        String name = this.getScriptName();
        String description = this.getDescription();
        return "".equals(description) ? name : name + " - " + description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() throws FileNotFoundException, IOException {
        String ret = "";
        LinebreakPreservingReader lpin = null;
        try {
            lpin = this.getUTF8LinebreakPreservingReader(this.m_file);
            StringBuilder sb = new StringBuilder();
            String s = lpin.readLine();
            this.startsWithBOM = s.startsWith("\ufeff");
            if (this.startsWithBOM) {
                s = s.substring(1);
            }
            while (s != null) {
                sb.append(s);
                String br = lpin.getLinebreak();
                if (!br.isEmpty()) {
                    this.lineBreak = br;
                    sb.append('\n');
                }
                s = lpin.readLine();
            }
            ret = sb.toString();
        }
        finally {
            if (lpin != null) {
                try {
                    lpin.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ret;
    }

    private LinebreakPreservingReader getUTF8LinebreakPreservingReader(File file) throws FileNotFoundException, UnsupportedEncodingException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "UTF-8");
        BufferedReader in = new BufferedReader(isr);
        return new LinebreakPreservingReader(in);
    }

    public void setText(String text) throws UnsupportedEncodingException, IOException {
        text = text.replaceAll("\n", this.lineBreak);
        if (this.startsWithBOM) {
            text = "\ufeff" + text;
        }
        FileUtils.writeStringToFile(this.m_file, text, "UTF-8");
    }

    public String toString() {
        return this.getScriptName();
    }

    @Override
    public int compareTo(ScriptItem o) {
        return this.getScriptName().compareTo(o.getScriptName());
    }
}

