/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.scripting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.io.FilenameUtils;
import org.omegat.core.Core;
import org.omegat.gui.scripting.ScriptItem;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class ScriptRunner {
    public static final String DEFAULT_SCRIPT = "javascript";
    public static final String VAR_CONSOLE = "console";
    public static final String VAR_MAINWINDOW = "mainWindow";
    public static final String VAR_GLOSSARY = "glossary";
    public static final String VAR_EDITOR = "editor";
    public static final String VAR_PROJECT = "project";
    public static final String VAR_RESOURCES = "res";
    public static final ScriptEngineManager MANAGER = new ScriptEngineManager(ScriptRunner.class.getClassLoader());

    public static String executeScript(ScriptItem item, Map<String, Object> additionalBindings) throws IOException, ScriptException {
        return ScriptRunner.executeScript(null, item, additionalBindings);
    }

    public static String executeScript(String script, ScriptItem item, Map<String, Object> additionalBindings) throws IOException, ScriptException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        if (additionalBindings != null) {
            bindings.putAll(additionalBindings);
        }
        bindings.put(VAR_RESOURCES, item.getResourceBundle());
        ScriptEngine engine = MANAGER.getEngineByExtension(FilenameUtils.getExtension(item.getFile().getName()));
        if (engine == null) {
            engine = MANAGER.getEngineByName(DEFAULT_SCRIPT);
        }
        if (StringUtil.isEmpty(script)) {
            script = item.getText();
        }
        StringBuilder result = new StringBuilder();
        Object eval = ScriptRunner.executeScript(script, engine, bindings);
        if (eval != null) {
            result.append(OStrings.getString("SCW_SCRIPT_RESULT")).append('\n');
            result.append(eval.toString()).append('\n');
        }
        return result.toString();
    }

    public static Object executeScript(String script, ScriptEngine engine, Map<String, Object> additionalBindings) throws ScriptException {
        SimpleBindings bindings = new SimpleBindings();
        bindings.put(VAR_PROJECT, (Object)Core.getProject());
        bindings.put(VAR_EDITOR, (Object)Core.getEditor());
        bindings.put(VAR_GLOSSARY, (Object)Core.getGlossary());
        bindings.put(VAR_MAINWINDOW, (Object)Core.getMainWindow());
        if (additionalBindings != null) {
            bindings.putAll((Map<? extends String, ? extends Object>)additionalBindings);
        }
        return engine.eval(script, (Bindings)bindings);
    }

    public static List<String> getAvailableScriptExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (ScriptEngineFactory engine : MANAGER.getEngineFactories()) {
            for (String ext : engine.getExtensions()) {
                extensions.add(ext);
            }
        }
        return extensions;
    }
}

