/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.languagetools;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Highlighter;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.bitext.BitextRule;
import org.languagetool.rules.bitext.DifferentLengthRule;
import org.languagetool.rules.bitext.SameTranslationRule;
import org.languagetool.tools.Tools;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.gui.Styles;

public class LanguageToolWrapper
implements IMarker,
IProjectEventListener {
    protected static final Highlighter.HighlightPainter PAINTER = new UnderlineFactory.WaveUnderline(Styles.EditorColor.COLOR_LANGUAGE_TOOLS.getColor());
    private JLanguageTool sourceLt;
    private JLanguageTool targetLt;
    private List<BitextRule> bRules;

    public LanguageToolWrapper() throws Exception {
        CoreEvents.registerProjectChangeListener(this);
    }

    public boolean isEnabled() {
        return Core.getEditor().getSettings().isMarkLanguageChecker();
    }

    @Override
    public synchronized void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CREATE: 
            case LOAD: {
                org.languagetool.Language sourceLang = this.getLTLanguage(Core.getProject().getProjectProperties().getSourceLanguage());
                org.languagetool.Language targetLang = this.getLTLanguage(Core.getProject().getProjectProperties().getTargetLanguage());
                this.sourceLt = this.getLanguageToolInstance(sourceLang);
                this.targetLt = this.getLanguageToolInstance(targetLang);
                if (this.sourceLt == null || this.targetLt == null) break;
                this.bRules = this.getBiTextRules(sourceLang, targetLang);
                break;
            }
            case CLOSE: {
                this.sourceLt = null;
                this.targetLt = null;
                break;
            }
        }
    }

    protected JLanguageTool getLanguageToolInstance(org.languagetool.Language ltLang) {
        JLanguageTool result = null;
        if (ltLang != null) {
            try {
                result = new JLanguageTool(ltLang);
                result.activateDefaultPatternRules();
            }
            catch (Exception ex) {
                result = null;
                Log.log(ex);
            }
        }
        return result;
    }

    @Override
    public synchronized List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        if (translationText == null || !this.isEnabled()) {
            return null;
        }
        JLanguageTool ltSource = this.sourceLt;
        JLanguageTool ltTarget = this.targetLt;
        if (ltTarget == null) {
            return null;
        }
        ArrayList<Mark> r = new ArrayList<Mark>();
        List<RuleMatch> matches = ltSource != null && this.bRules != null ? Tools.checkBitext(sourceText, translationText, ltSource, ltTarget, this.bRules) : ltTarget.check(translationText);
        for (RuleMatch match : matches) {
            Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, match.getFromPos(), match.getToPos());
            m.toolTipText = match.getMessage();
            m.painter = PAINTER;
            r.add(m);
        }
        return r;
    }

    private org.languagetool.Language getLTLanguage(Language lang) {
        String omLang = lang.getLanguageCode();
        for (org.languagetool.Language ltLang : org.languagetool.Language.LANGUAGES) {
            if (!omLang.equalsIgnoreCase(ltLang.getShortName())) continue;
            return ltLang;
        }
        return null;
    }

    private List<BitextRule> getBiTextRules(org.languagetool.Language sourceLang, org.languagetool.Language targetLang) {
        List<BitextRule> result;
        try {
            result = Tools.getBitextRules(sourceLang, targetLang);
        }
        catch (Exception ex) {
            return null;
        }
        for (int i = 0; i < result.size(); ++i) {
            if (result.get(i) instanceof DifferentLengthRule) {
                result.remove(i);
                --i;
                continue;
            }
            if (!(result.get(i) instanceof SameTranslationRule)) continue;
            result.remove(i);
            --i;
        }
        return result;
    }
}

