/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.tokenizer;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.Version;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.WordIterator;
import org.omegat.util.PatternConsts;
import org.omegat.util.StringUtil;
import org.omegat.util.Token;

public class DefaultTokenizer
implements ITokenizer {
    private static Map<String, Token[]> tokenCache = new HashMap<String, Token[]>(5000);
    private static final Token[] EMPTY_TOKENS_LIST = new Token[0];
    private static final String[] EMPTY_STRINGS_LIST = new String[0];

    public DefaultTokenizer() {
        CoreEvents.registerProjectChangeListener(new IProjectEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                if (eventType == IProjectEventListener.PROJECT_CHANGE_TYPE.CLOSE) {
                    Map map = tokenCache;
                    synchronized (map) {
                        tokenCache.clear();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Token[] tokenizeWords(String strOrig, ITokenizer.StemmingMode stemmingMode) {
        Token[] result;
        if (StringUtil.isEmpty(strOrig)) {
            return EMPTY_TOKENS_LIST;
        }
        Map<String, Token[]> map = tokenCache;
        synchronized (map) {
            result = tokenCache.get(strOrig);
        }
        if (result != null) {
            return result;
        }
        result = DefaultTokenizer.tokenizeTextNoCache(strOrig, false);
        map = tokenCache;
        synchronized (map) {
            tokenCache.put(strOrig, result);
        }
        return result;
    }

    @Override
    public String[] tokenizeWordsToStrings(String str, ITokenizer.StemmingMode stemmingMode) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY_STRINGS_LIST;
        }
        return DefaultTokenizer.tokenizeTextToStringsNoCache(str, false);
    }

    @Override
    public Token[] tokenizeVerbatim(String strOrig) {
        return DefaultTokenizer.tokenizeTextNoCache(strOrig, true);
    }

    @Override
    public String[] tokenizeVerbatimToStrings(String str) {
        return DefaultTokenizer.tokenizeTextToStringsNoCache(str, true);
    }

    private static Token[] tokenizeTextNoCache(String strOrig, boolean all) {
        if (StringUtil.isEmpty(strOrig)) {
            return EMPTY_TOKENS_LIST;
        }
        ArrayList<Token> tokens = new ArrayList<Token>(64);
        BreakIterator breaker = DefaultTokenizer.getWordBreaker();
        breaker.setText(strOrig);
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            String tokenStr = strOrig.substring(start, end);
            if (all) {
                tokens.add(new Token(tokenStr, start));
            } else {
                int cp;
                boolean word = false;
                for (int i = 0; i < tokenStr.length(); i += Character.charCount(cp)) {
                    cp = tokenStr.codePointAt(i);
                    if (!Character.isLetter(cp)) continue;
                    word = true;
                    break;
                }
                if (word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                    tokens.add(new Token(tokenStr, start));
                }
            }
            start = end;
            end = breaker.next();
        }
        return tokens.toArray(new Token[tokens.size()]);
    }

    private static String[] tokenizeTextToStringsNoCache(String str, boolean all) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY_STRINGS_LIST;
        }
        ArrayList<String> tokens = new ArrayList<String>(64);
        BreakIterator breaker = DefaultTokenizer.getWordBreaker();
        breaker.setText(str);
        int start = breaker.first();
        int end = breaker.next();
        while (end != -1) {
            String tokenStr = str.substring(start, end);
            if (all) {
                tokens.add(tokenStr);
            } else {
                int cp;
                boolean word = false;
                for (int i = 0; i < tokenStr.length(); i += Character.charCount(cp)) {
                    cp = tokenStr.codePointAt(i);
                    if (!Character.isLetter(cp)) continue;
                    word = true;
                    break;
                }
                if (word && !PatternConsts.OMEGAT_TAG.matcher(tokenStr).matches()) {
                    tokens.add(tokenStr);
                }
            }
            start = end;
            end = breaker.next();
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static BreakIterator getWordBreaker() {
        return new WordIterator();
    }

    public static boolean isContains(Token[] tokensList, Token tokenForCheck) {
        for (Token t : tokensList) {
            if (!tokenForCheck.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsAll(Token[] tokensList, Token[] listForFind, boolean notExact) {
        if (notExact) {
            for (Token t : listForFind) {
                if (DefaultTokenizer.isContains(tokensList, t)) continue;
                return false;
            }
            return true;
        }
        return DefaultTokenizer.isContainsExact(tokensList, listForFind);
    }

    private static boolean isContainsExact(Token[] tokensList, Token[] listForFind) {
        for (int i = 0; i < tokensList.length; ++i) {
            if (!tokensList[i].equals(listForFind[0])) continue;
            if (listForFind.length == 1) {
                return true;
            }
            int k = i + 1;
            if (listForFind.length <= tokensList.length - k + 1) {
                boolean found = true;
                for (int j = 1; j < listForFind.length; ++j) {
                    if (!listForFind[j].equals(tokensList[k])) {
                        found = false;
                        break;
                    }
                    ++k;
                }
                if (!found) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Map<Version, String> getSupportedBehaviors() {
        return Collections.emptyMap();
    }

    @Override
    public Version getBehavior() {
        return null;
    }

    @Override
    public Version getDefaultBehavior() {
        return null;
    }

    @Override
    public void setBehavior(Version behavior) {
    }

    @Override
    public String[] getSupportedLanguages() {
        return new String[0];
    }
}

