/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.omegat.gui.main.MainWindow;

public class DragTargetOverlay {
    private static int MARGIN = 0;

    public static void apply(final JComponent comp, final IDropInfo info) {
        DropTargetAdapter listener = new DropTargetAdapter(){
            private JPanel panel = null;

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
                if (!dtde.isDataFlavorSupported(info.getDataFlavor()) || !info.canAcceptDrop()) {
                    return;
                }
                final JLayeredPane layeredPane = SwingUtilities.getRootPane(comp).getLayeredPane();
                if (this.panel == null) {
                    this.panel = DragTargetOverlay.createOverlayPanel(comp, layeredPane, info);
                }
                layeredPane.add((Component)this.panel, JLayeredPane.MODAL_LAYER);
                Rectangle rect = this.calculateBounds(info.getComponentToOverlay());
                this.panel.setBounds(rect);
                this.panel.doLayout();
                layeredPane.repaint();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        layeredPane.repaint();
                    }
                });
            }

            private Rectangle calculateBounds(Component overlayComponent) {
                JRootPane rootPane = SwingUtilities.getRootPane(overlayComponent);
                Rectangle rect = SwingUtilities.convertRectangle(overlayComponent.getParent(), overlayComponent.getBounds(), rootPane.getContentPane());
                JMenuBar menuBar = rootPane.getJMenuBar();
                rect.x += MARGIN;
                rect.y = rect.y + (MARGIN + (menuBar == null ? 0 : menuBar.getHeight()));
                rect.width -= MARGIN * 2;
                rect.height -= MARGIN * 2;
                return rect;
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
            }
        };
        DragTargetOverlay.addListener(comp, listener);
    }

    private static JPanel createOverlayPanel(JComponent comp, final JLayeredPane layeredPane, IDropInfo info) {
        final JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel("<html><center>" + info.getOverlayMessage() + "</center></html>");
        label.setForeground(Color.WHITE);
        label.setHorizontalAlignment(0);
        label.setFont(label.getFont().deriveFont(1));
        label.setBorder(new EmptyBorder(20, 20, 20, 20));
        panel.add((Component)label, "Center");
        panel.setBackground(new Color(0, 0, 0, 150));
        DragTargetOverlay.addListener(panel, new FileDropListener(info){

            @Override
            public void drop(DropTargetDropEvent dtde) {
                super.drop(dtde);
                this.restore();
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
                this.restore();
            }

            private void restore() {
                layeredPane.remove(panel);
                layeredPane.repaint();
            }
        });
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                layeredPane.remove(panel);
                layeredPane.repaint();
            }
        });
        return panel;
    }

    private static void addListener(JComponent comp, DropTargetListener listener) {
        DropTarget target = comp.getDropTarget();
        if (target == null) {
            comp.setDropTarget(new DropTarget(comp, listener));
        } else {
            try {
                target.addDropTargetListener(listener);
            }
            catch (TooManyListenersException e) {
                e.printStackTrace();
            }
        }
    }

    public static abstract class FileDropInfo
    implements IDropInfo {
        private final MainWindow mw;
        private final boolean doReset;

        public FileDropInfo(MainWindow mw, boolean doReset) {
            this.mw = mw;
            this.doReset = doReset;
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DataFlavor.javaFileListFlavor;
        }

        @Override
        public int getDnDAction() {
            return 1;
        }

        private List<File> filterFiles(List<?> files) {
            ArrayList<File> filtered = new ArrayList<File>(files.size());
            for (Object o : files) {
                File file = (File)o;
                if (!file.exists() || !file.canRead() || !this.acceptFile(file)) continue;
                filtered.add(file);
            }
            return filtered;
        }

        @Override
        public boolean handleDroppedObject(Object dropped) {
            return this.handleFiles(this.filterFiles((List)dropped));
        }

        protected boolean handleFiles(final List<File> files) {
            if (files.isEmpty()) {
                return false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileDropInfo.this.mw.importFiles(FileDropInfo.this.getImportDestination(), files.toArray(new File[files.size()]), FileDropInfo.this.doReset);
                }
            });
            return true;
        }

        protected abstract boolean acceptFile(File var1);

        protected abstract String getImportDestination();
    }

    public static interface IDropInfo {
        public DataFlavor getDataFlavor();

        public int getDnDAction();

        public boolean canAcceptDrop();

        public Component getComponentToOverlay();

        public String getOverlayMessage();

        public boolean handleDroppedObject(Object var1);
    }

    private static class FileDropListener
    extends DropTargetAdapter {
        private final IDropInfo info;

        public FileDropListener(IDropInfo info) {
            this.info = info;
        }

        private void verifyDrag(DropTargetDragEvent dtde) {
            if (dtde.isDataFlavorSupported(this.info.getDataFlavor()) && (dtde.getSourceActions() & this.info.getDnDAction()) != 0) {
                dtde.acceptDrag(this.info.getDnDAction());
            } else {
                dtde.rejectDrag();
            }
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.verifyDrag(dtde);
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            this.verifyDrag(dtde);
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.verifyDrag(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.acceptDrop(this.info.getDnDAction());
            Transferable transferable = dtde.getTransferable();
            boolean success = false;
            try {
                Object result = transferable.getTransferData(this.info.getDataFlavor());
                success = this.info.handleDroppedObject(result);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dtde.dropComplete(success);
        }
    }
}

