/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.tm;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.util.OStrings;
import org.silvestrislab.cyclotis.omegat.Cyclotis;

public abstract class SaveConditions {
    private static final ScriptEngineManager manager = new ScriptEngineManager(SaveConditions.forProperty("true").getClass().getClassLoader());
    private static final ScriptEngine scriptEngine = manager.getEngineByName("javascript");
    private static int count = 0;

    public abstract boolean mustWrite(Cyclotis var1, PrepareTMXEntry var2, SourceTextEntry var3);

    public static SaveConditions forProperty(final String property) {
        if (property.equalsIgnoreCase("nonfuzzy")) {
            return new SaveConditions(){

                @Override
                public boolean mustWrite(Cyclotis parent, PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
                    return !entryContents.translation.startsWith("[fuzzy]") && !entryContents.translation.startsWith(OStrings.getString((String)"WF_DEFAULT_PREFIX"));
                }

                public String toString() {
                    return "Non-fuzzy";
                }
            };
        }
        if (property.equalsIgnoreCase("nonsrc")) {
            return new SaveConditions(){

                @Override
                public boolean mustWrite(Cyclotis parent, PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
                    return !entryContents.translation.equals(entryContents.source);
                }

                public String toString() {
                    return "Non-fuzzy";
                }
            };
        }
        if (property.toLowerCase().startsWith("js:")) {
            return new SaveConditions(){
                String expression;
                int id;
                {
                    this.expression = property.substring(3);
                    this.id = count;
                    try {
                        scriptEngine.eval("function mustWrite" + count + "(project,contents,source) { return " + this.expression + "; }");
                        count++;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public boolean mustWrite(Cyclotis parent, PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
                    try {
                        Invocable inv = (Invocable)((Object)scriptEngine);
                        Object eval = inv.invokeFunction("mustWrite" + this.id, Core.getProject(), entryContents, entrySource);
                        parent.logMessage("javascript", this.expression + " evaluated as " + eval);
                        if (eval == null) {
                            return false;
                        }
                        if (eval.toString().equalsIgnoreCase("false")) {
                            return false;
                        }
                        if (eval.toString().equalsIgnoreCase("0")) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        parent.logMessage("javascript", this.expression + " not evaluated : " + e);
                        return false;
                    }
                    return true;
                }

                public String toString() {
                    return "javascript:" + this.expression;
                }
            };
        }
        return new SaveConditions(){
            boolean constValue;
            {
                this.constValue = property.equalsIgnoreCase("true");
            }

            @Override
            public boolean mustWrite(Cyclotis parent, PrepareTMXEntry entryContents, SourceTextEntry entrySource) {
                return this.constValue;
            }

            public String toString() {
                return "Always " + this.constValue;
            }
        };
    }
}

