/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.spelling.hunspell.HunspellNoSuggestionRule;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.da.DanishTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.da.DanishRuleDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class Danish
extends Language {
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Disambiguator disambiguator;

    public final String getName() {
        return "Danish";
    }

    public final String getShortName() {
        return "da";
    }

    public final String[] getCountryVariants() {
        return new String[]{"DK"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\"", "\u201d"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\"", "\u201d"};
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new DanishTagger();
        }
        return this.tagger;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public final Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new DanishRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public final Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Esben Aaberg"), new Contributor("Henrik Bendt")};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, GenericUnpairedBracketsRule.class, HunspellNoSuggestionRule.class, UppercaseSentenceStartRule.class, WhitespaceRule.class);
    }
}

