/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tools.StringTools;

public class AnalyzedGermanTokenReadings
extends AnalyzedTokenReadings {
    public AnalyzedGermanTokenReadings(AnalyzedGermanToken[] aTokens, int startPos) {
        super((AnalyzedToken[])aTokens, startPos);
    }

    public AnalyzedGermanTokenReadings(AnalyzedGermanToken aToken, int startPos) {
        super((AnalyzedToken)aToken, startPos);
    }

    public List<AnalyzedGermanToken> getGermanReadings() {
        ArrayList<AnalyzedGermanToken> tokens = new ArrayList<AnalyzedGermanToken>();
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() != null) {
                if (reading.getPOSTag().equals("SENT_END") || reading.getPOSTag().equals("PARA_END")) continue;
                tokens.add((AnalyzedGermanToken)reading);
                continue;
            }
            tokens.add((AnalyzedGermanToken)reading);
        }
        return tokens;
    }

    public boolean hasReadingOfType(GermanToken.POSType type) {
        if (this.anTokReadings == null) {
            return false;
        }
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() != null && (reading.getPOSTag().equals("SENT_END") || reading.getPOSTag().equals("PARA_END"))) {
                return false;
            }
            AnalyzedGermanToken germanReading = (AnalyzedGermanToken)reading;
            if (germanReading.getType() != type) continue;
            return true;
        }
        return false;
    }

    public boolean isSentenceEnd() {
        if (this.anTokReadings == null) {
            return false;
        }
        for (AnalyzedToken reading : this.anTokReadings) {
            if (reading.getPOSTag() == null || !reading.getPOSTag().equals("SENT_END") && !reading.getPOSTag().equals("PARA_END")) continue;
            return true;
        }
        return false;
    }

    public boolean hasReading(GermanToken.Kasus kasus) {
        if (this.anTokReadings == null) {
            return false;
        }
        for (AnalyzedToken reading : this.anTokReadings) {
            AnalyzedGermanToken germanReading = (AnalyzedGermanToken)reading;
            if (germanReading.getCasus() != kasus) continue;
            return true;
        }
        return false;
    }

    public boolean hasReading(GermanToken.Numerus numerus) {
        if (this.anTokReadings == null) {
            return false;
        }
        for (AnalyzedToken reading : this.anTokReadings) {
            AnalyzedGermanToken germanReading = (AnalyzedGermanToken)reading;
            if (germanReading.getNumerus() != numerus) continue;
            return true;
        }
        return false;
    }

    public boolean hasReading(GermanToken.Genus genus) {
        if (this.anTokReadings == null) {
            return false;
        }
        for (AnalyzedToken reading : this.anTokReadings) {
            AnalyzedGermanToken germanReading = (AnalyzedGermanToken)reading;
            if (germanReading.getGenus() != genus) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.anTokReadings == null) {
            return super.getAnalyzedToken(0).getToken() + "[?]";
        }
        StringBuilder sb = new StringBuilder(super.getAnalyzedToken(0).getToken());
        HashSet<String> printed = new HashSet<String>();
        sb.append('[');
        for (AnalyzedToken reading : this.anTokReadings) {
            if (!printed.contains(reading.toString())) {
                if (printed.size() > 0) {
                    sb.append(", ");
                }
                sb.append(reading.toString());
            }
            printed.add(reading.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public String toSortedString() {
        if (this.anTokReadings == null) {
            return super.getAnalyzedToken(0).getToken() + "[?]";
        }
        StringBuilder sb = new StringBuilder(super.getAnalyzedToken(0).getToken());
        TreeSet<String> elements = new TreeSet<String>();
        sb.append('[');
        for (AnalyzedToken reading : this.anTokReadings) {
            if (elements.contains(reading.toString())) continue;
            elements.add(reading.toString());
        }
        sb.append(StringTools.listToString(elements, (String)", "));
        sb.append(']');
        return sb.toString();
    }
}

