/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa;

import morfologik.fsa.FSA;
import morfologik.fsa.FSAFlags;
import morfologik.fsa.MatchResult;

public final class FSATraversal {
    private final FSA fsa;

    public FSATraversal(FSA fsa) {
        this.fsa = fsa;
    }

    public int perfectHash(byte[] sequence, int start, int length, int node) {
        assert (this.fsa.getFlags().contains((Object)FSAFlags.NUMBERS)) : "FSA not built with NUMBERS option.";
        assert (length > 0) : "Must be a non-empty sequence.";
        int hash = 0;
        int end = start + length - 1;
        int seqIndex = start;
        byte label = sequence[seqIndex];
        int arc = this.fsa.getFirstArc(node);
        while (arc != 0) {
            if (this.fsa.getArcLabel(arc) == label) {
                if (this.fsa.isArcFinal(arc)) {
                    if (seqIndex == end) {
                        return hash;
                    }
                    ++hash;
                }
                if (this.fsa.isArcTerminal(arc)) {
                    return -3;
                }
                if (seqIndex == end) {
                    return -4;
                }
                arc = this.fsa.getFirstArc(this.fsa.getEndNode(arc));
                label = sequence[++seqIndex];
                continue;
            }
            if (this.fsa.isArcFinal(arc)) {
                ++hash;
            }
            if (!this.fsa.isArcTerminal(arc)) {
                hash += this.fsa.getRightLanguageCount(this.fsa.getEndNode(arc));
            }
            arc = this.fsa.getNextArc(arc);
        }
        return -1;
    }

    public int perfectHash(byte[] sequence) {
        return this.perfectHash(sequence, 0, sequence.length, this.fsa.getRootNode());
    }

    public MatchResult match(MatchResult result, byte[] sequence, int start, int length, int node) {
        if (node == 0) {
            result.reset(-1, start, node);
            return result;
        }
        FSA fsa = this.fsa;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            int arc = fsa.getArc(node, sequence[i]);
            if (arc != 0) {
                if (fsa.isArcFinal(arc) && i + 1 == end) {
                    result.reset(0, i, node);
                    return result;
                }
                if (fsa.isArcTerminal(arc)) {
                    result.reset(-3, i + 1, 0);
                    return result;
                }
            } else {
                result.reset(-1, i, node);
                return result;
            }
            node = fsa.getEndNode(arc);
        }
        result.reset(-4, 0, node);
        return result;
    }

    public MatchResult match(byte[] sequence, int start, int length, int node) {
        return this.match(new MatchResult(), sequence, start, length, node);
    }

    public MatchResult match(byte[] sequence, int node) {
        return this.match(sequence, 0, sequence.length, node);
    }

    public MatchResult match(byte[] sequence) {
        return this.match(sequence, this.fsa.getRootNode());
    }
}

