/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.madlonkay.supertmxmerge.DiffIOController;
import org.madlonkay.supertmxmerge.MergeController;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTmx;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.gui.ProgressWindow;
import org.madlonkay.supertmxmerge.util.FileUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class MergeIOController
extends DiffIOController {
    private static final Logger LOGGER = Logger.getLogger(MergeIOController.class.getName());
    public static final String PROP_MERGEBASEFILE = "mergeBaseFile";
    private File baseFile;

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(File baseFile) {
        File oldBaseFile = this.baseFile;
        this.baseFile = baseFile;
        this.propertySupport.firePropertyChange(PROP_MERGEBASEFILE, oldBaseFile, baseFile);
        this.propertySupport.firePropertyChange("inputIsValid", null, null);
    }

    @Override
    public boolean getInputIsValid() {
        return !(!FileUtil.validateFile(this.getFile1()) || !FileUtil.validateFile(this.getFile2()) || this.getBaseFile() != null && this.getBaseFile().equals(this.getFile1()) || this.getBaseFile() != null && this.getBaseFile().equals(this.getFile2()) || this.getFile1().equals(this.getFile2()));
    }

    @Override
    public void go() {
        JAXBTmx baseTmx;
        JAXBTmx rightTmx;
        JAXBTmx leftTmx;
        MergeController merger = new MergeController();
        if (this.getOutputFile() != null) {
            merger.setQuiet(true);
        }
        ProgressWindow progress = null;
        if (!GraphicsEnvironment.isHeadless()) {
            progress = new ProgressWindow();
            progress.setMaximum(3);
        }
        try {
            this.updateProgress(progress, 0, LocString.getFormat("STM_FILE_PROGRESS", this.getFile1().getName(), 1, 3));
            leftTmx = new JAXBTmx(this.getFile1());
            this.updateProgress(progress, 1, LocString.getFormat("STM_FILE_PROGRESS", this.getFile2().getName(), 2, 3));
            rightTmx = new JAXBTmx(this.getFile2());
            this.updateProgress(progress, 2, LocString.getFormat("STM_FILE_PROGRESS", this.getBaseFile() == null ? LocString.get("STM_EMPTY_TMX_NAME") : this.getBaseFile().getName(), 3, 3));
            if (this.getBaseFile() == null || this.getBaseFile().length() == 0L) {
                baseTmx = JAXBTmx.newEmptyJAXBTmx(leftTmx);
                merger.setIsTwoWayMerge(true);
            } else {
                baseTmx = new JAXBTmx(this.getBaseFile());
            }
            this.updateProgress(progress, 3, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (progress != null) {
                GuiUtil.closeWindow(progress);
            }
        }
        ITmx merged = merger.merge(baseTmx, leftTmx, rightTmx);
        if (merged == null) {
            return;
        }
        while (this.getOutputFile() == null) {
            JFileChooser chooser = new JFileChooser();
            if (chooser.showSaveDialog(null) == 0) {
                this.setOutputFile(chooser.getSelectedFile());
                continue;
            }
            int response = JOptionPane.showConfirmDialog(null, LocString.get("STM_CONFIRM_CANCEL_SAVE_MESSAGE"), LocString.get("STM_MERGE_WINDOW_TITLE"), 0, 2);
            if (response != 0) continue;
            return;
        }
        try {
            merged.writeTo(this.getOutputFile());
        }
        catch (WriteFailedException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }
}

