/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.data.JAXB;

import gen.core.tmx14.Body;
import gen.core.tmx14.Header;
import gen.core.tmx14.Prop;
import gen.core.tmx14.Tmx;
import gen.core.tmx14.Tu;
import gen.core.tmx14.Tuv;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.madlonkay.supertmxmerge.data.DiffAnalysis;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITu;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTu;
import org.madlonkay.supertmxmerge.data.JAXB.JAXBTuv;
import org.madlonkay.supertmxmerge.data.JAXB.TmxWriter;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.ResolutionSet;
import org.madlonkay.supertmxmerge.data.WriteFailedException;
import org.madlonkay.supertmxmerge.util.DiffUtil;
import org.madlonkay.supertmxmerge.util.LocString;
import org.madlonkay.supertmxmerge.util.ReflectionUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class JAXBTmx
implements ITmx {
    public static final String DIFF_PROP_TYPE = "x-diff-type";
    public static final String DIFF_PROP_VALUE_ADDED = "added";
    public static final String DIFF_PROP_VALUE_DELETED = "deleted";
    public static final String DIFF_PROP_VALUE_MODIFIED = "modified";
    public static final String DIFF_PROP_MODIFIED_TYPE = "x-diff-modified";
    public static final String DIFF_PROP_MODIFIED_VALUE_BEFORE = "before";
    public static final String DIFF_PROP_MODIFIED_VALUE_AFTER = "after";
    private static final JAXBContext CONTEXT;
    private static final Unmarshaller UNMARSHALLER;
    private static final Marshaller MARSHALLER;
    private static final XMLReader XMLREADER;
    private final PropertyChangeSupport propertySupport;
    private Tmx tmx;
    private final String name;
    private File file;
    private Map<Key, ITuv> tuvMap;
    private Map<Key, ITu> tuMap;
    private Map<String, String> tmxMetadata;
    private static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    private static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    private static final Logger LOGGER;

    public static JAXBTmx createFromDiff(JAXBTmx tmx1, JAXBTmx tmx2) {
        Prop prop;
        Tu tu;
        try {
            tmx1 = tmx1.klone();
            tmx2 = tmx2.klone();
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        DiffAnalysis set = DiffUtil.mapDiff(tmx1, tmx2);
        Tmx tmx = JAXBTmx.newEmptyTmx(tmx2.tmx);
        Body body = tmx.getBody();
        for (Key key : set.added) {
            tu = (Tu)tmx2.tuMap.get(key).getUnderlyingRepresentation();
            body.getTu().add(tu);
            prop = new Prop();
            tu.getNoteOrProp().add(prop);
            prop.setType(DIFF_PROP_TYPE);
            prop.setContent(DIFF_PROP_VALUE_ADDED);
        }
        for (Key key : set.deleted) {
            tu = (Tu)tmx1.tuMap.get(key).getUnderlyingRepresentation();
            body.getTu().add(tu);
            prop = new Prop();
            tu.getNoteOrProp().add(prop);
            prop.setType(DIFF_PROP_TYPE);
            prop.setContent(DIFF_PROP_VALUE_DELETED);
        }
        for (Key key : set.modified) {
            JAXBTu tu1 = (JAXBTu)tmx1.tuMap.get(key);
            Tu tu2 = (Tu)tu1.getUnderlyingRepresentation();
            body.getTu().add(tu2);
            JAXBTu tu22 = (JAXBTu)tmx2.tuMap.get(key);
            tu2.getTuv().add((Tuv)tu22.getTargetTuv().getUnderlyingRepresentation());
            Prop prop2 = new Prop();
            tu2.getNoteOrProp().add(prop2);
            prop2.setType(DIFF_PROP_TYPE);
            prop2.setContent(DIFF_PROP_VALUE_MODIFIED);
            Prop prop1 = new Prop();
            Tuv tuv1 = (Tuv)tu1.getTargetTuv().getUnderlyingRepresentation();
            tuv1.getNoteOrProp().add(prop1);
            prop1.setType(DIFF_PROP_MODIFIED_TYPE);
            prop1.setContent(DIFF_PROP_MODIFIED_VALUE_BEFORE);
            Prop prop22 = new Prop();
            Tuv tuv2 = (Tuv)tu22.getTargetTuv().getUnderlyingRepresentation();
            tuv2.getNoteOrProp().add(prop22);
            prop22.setType(DIFF_PROP_MODIFIED_TYPE);
            prop22.setContent(DIFF_PROP_MODIFIED_VALUE_AFTER);
        }
        return new JAXBTmx(tmx, "diff");
    }

    public JAXBTmx(File file) throws Exception {
        this.propertySupport = new PropertyChangeSupport(this);
        this.name = file.getName();
        this.file = file;
        SAXSource source = new SAXSource(XMLREADER, new InputSource(new FileInputStream(file)));
        this.tmx = (Tmx)UNMARSHALLER.unmarshal((Source)source);
        this.generateMaps();
    }

    private JAXBTmx(Tmx tmx, String name) {
        this.tmx = tmx;
        this.name = name;
        this.propertySupport = new PropertyChangeSupport(this);
        this.generateMaps();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    @Override
    public String getSourceLanguage() {
        return this.tmx.getHeader().getSrclang();
    }

    @Override
    public int getSize() {
        return this.tmx.getBody().getTu().size();
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void generateMaps() {
        this.tuvMap = new HashMap<Key, ITuv>();
        this.tuMap = new HashMap<Key, ITu>();
        for (Tu rawTu : this.tmx.getBody().getTu()) {
            JAXBTu tu = new JAXBTu(rawTu, this.getSourceLanguage());
            Key key = tu.getKey();
            assert (!this.tuMap.containsKey(key));
            assert (!this.tuvMap.containsKey(key));
            this.tuMap.put(key, tu);
            ITuv tuv = tu.getTargetTuv();
            this.tuvMap.put(key, tuv == null ? JAXBTuv.EMPTY_TUV : tuv);
        }
    }

    @Override
    public Map<String, String> getMetadata() {
        if (this.tmxMetadata == null) {
            this.tmxMetadata = ReflectionUtil.simplePropsToMap(this.tmx.getHeader());
            if (this.file != null) {
                this.tmxMetadata.put("Path", this.file.getAbsolutePath());
            }
            this.tmxMetadata = Collections.unmodifiableMap(this.tmxMetadata);
        }
        return this.tmxMetadata;
    }

    @Override
    public ITmx applyChanges(ResolutionSet resolution) {
        Tmx originalData;
        try {
            originalData = JAXBTmx.clone(this.tmx);
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        List tus = this.tmx.getBody().getTu();
        for (Key key : resolution.toDelete) {
            tus.remove((Tu)this.tuMap.get(key).getUnderlyingRepresentation());
        }
        for (Map.Entry entry : resolution.toReplace.entrySet()) {
            Tu tu = (Tu)this.tuMap.get(entry.getKey()).getUnderlyingRepresentation();
            ITuv tuvToRemove = this.tuvMap.get(entry.getKey());
            if (tuvToRemove == null) continue;
            tu.getTuv().remove((Tuv)tuvToRemove.getUnderlyingRepresentation());
            tu.getTuv().add((Tuv)((ITuv)entry.getValue()).getUnderlyingRepresentation());
        }
        for (ITu iTu : resolution.toAdd.values()) {
            tus.add((Tu)iTu.getUnderlyingRepresentation());
        }
        Tmx modifiedData = this.tmx;
        this.tmx = originalData;
        this.generateMaps();
        return new JAXBTmx(modifiedData, LocString.get("STM_MERGED_TMX_NAME"));
    }

    public JAXBTmx klone() throws JAXBException {
        return new JAXBTmx(JAXBTmx.clone(this.tmx), this.name);
    }

    public static Tmx clone(Tmx jaxbObject) throws JAXBException {
        StringWriter xml = new StringWriter();
        MARSHALLER.marshal((Object)jaxbObject, (Writer)xml);
        StringReader reader = new StringReader(xml.toString());
        SAXSource source = new SAXSource(XMLREADER, new InputSource(reader));
        return (Tmx)UNMARSHALLER.unmarshal((Source)source);
    }

    @Override
    public void writeTo(File output) throws WriteFailedException {
        try {
            FileOutputStream stream = new FileOutputStream(output);
            XMLStreamWriter writer = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, "UTF-8");
            MARSHALLER.marshal((Object)this.tmx, (XMLStreamWriter)new TmxWriter(writer));
        }
        catch (FileNotFoundException ex) {
            throw new WriteFailedException(ex);
        }
        catch (JAXBException ex) {
            throw new WriteFailedException(ex);
        }
        catch (XMLStreamException ex) {
            throw new WriteFailedException(ex);
        }
    }

    @Override
    public Object getUnderlyingRepresentation() {
        return this.tmx;
    }

    private static Tmx newEmptyTmx(Tmx orig) {
        Tmx tmx = new Tmx();
        tmx.setVersion("1.1");
        Package pkg = JAXBTmx.class.getPackage();
        Header header = new Header();
        tmx.setHeader(header);
        if (pkg != null) {
            header.setCreationtool(pkg.getImplementationTitle());
            header.setCreationtoolversion(pkg.getImplementationVersion());
        }
        if (orig != null) {
            tmx.setVersion(orig.getVersion());
            header.setOTmf(orig.getHeader().getOTmf());
            header.setSrclang(orig.getHeader().getSrclang());
        }
        Body body = new Body();
        tmx.setBody(body);
        return tmx;
    }

    public static JAXBTmx newEmptyJAXBTmx(JAXBTmx orig) {
        return new JAXBTmx(JAXBTmx.newEmptyTmx(orig == null ? null : orig.tmx), LocString.get("STM_NEW_TMX_NAME"));
    }

    @Override
    public ITu getTu(Key key) {
        return this.tuMap.get(key);
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.tuvMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ITuv get(Object key) {
        return this.tuvMap.get(key);
    }

    @Override
    public ITuv put(Key key, ITuv value) {
        return this.tuvMap.put(key, value);
    }

    @Override
    public ITuv remove(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putAll(Map<? extends Key, ? extends ITuv> m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Key> keySet() {
        return this.tuvMap.keySet();
    }

    @Override
    public Collection<ITuv> values() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set<Map.Entry<Key, ITuv>> entrySet() {
        return this.tuvMap.entrySet();
    }

    static {
        LOGGER = Logger.getLogger(JAXBTmx.class.getName());
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Tmx.class});
            UNMARSHALLER = CONTEXT.createUnmarshaller();
            MARSHALLER = CONTEXT.createMarshaller();
            MARSHALLER.setProperty("jaxb.encoding", (Object)"UTF-8");
            XMLReader xmlreader = XMLReaderFactory.createXMLReader();
            xmlreader.setFeature(FEATURE_NAMESPACES, true);
            xmlreader.setFeature(FEATURE_NAMESPACE_PREFIXES, true);
            xmlreader.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    File systemFile = new File(systemId);
                    InputSource s = new InputSource(JAXBTmx.class.getResourceAsStream("/schemas/" + systemFile.getName()));
                    return s;
                }
            });
            XMLREADER = xmlreader;
        }
        catch (JAXBException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXNotRecognizedException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
    }
}

