/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.io;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import net.moraleboost.io.CodePointReader;

public class BasicCodePointReader
implements CodePointReader {
    public static final int DEFAULT_ALTERNATION_CODEPOINT = 12307;
    private PushbackReader reader = null;
    private long position = 0L;
    private int alternationCodePoint = 12307;
    private boolean eos = false;

    public BasicCodePointReader(Reader reader) {
        this.reader = new PushbackReader(reader, 1);
    }

    public void setAlternationCodePoint(int cp) {
        this.alternationCodePoint = cp;
    }

    public int getAlternationCodePoint() {
        return this.alternationCodePoint;
    }

    public long getPosition() {
        return this.position;
    }

    public int read() throws IOException {
        if (this.eos) {
            return -1;
        }
        int ci = this.reader.read();
        ++this.position;
        if (ci < 0) {
            this.eos = true;
            return -1;
        }
        char c = (char)ci;
        if (Character.isHighSurrogate(c)) {
            ci = this.reader.read();
            ++this.position;
            if (ci < 0) {
                this.eos = true;
                --this.position;
                return this.alternationCodePoint;
            }
            char c2 = (char)ci;
            if (Character.isLowSurrogate(c2)) {
                return Character.toCodePoint(c, c2);
            }
            this.reader.unread(c2);
            --this.position;
            return this.alternationCodePoint;
        }
        if (Character.isLowSurrogate(c)) {
            return this.alternationCodePoint;
        }
        return c;
    }

    public void reset() {
        this.position = 0L;
        this.eos = false;
    }
}

