/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;

public abstract class CharsetUtil {
    public static CharsetEncoder createEncoder(String charset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        Charset cset = Charset.forName(charset);
        if (!cset.canEncode()) {
            throw new UnsupportedCharsetException(charset);
        }
        CharsetEncoder encoder = cset.newEncoder();
        encoder.onMalformedInput(malformedInputAction);
        encoder.onUnmappableCharacter(unmappableCharacterAction);
        return encoder;
    }

    public static CharsetDecoder createDecoder(String charset, CodingErrorAction malformedInputAction, CodingErrorAction unmappableCharacterAction) {
        Charset cset = Charset.forName(charset);
        CharsetDecoder decoder = cset.newDecoder();
        decoder.onMalformedInput(malformedInputAction);
        decoder.onUnmappableCharacter(unmappableCharacterAction);
        return decoder;
    }

    public static byte[] encode(CharsetEncoder encoder, CharSequence text, boolean terminateWithNull) throws CharacterCodingException {
        byte[] ret;
        encoder.reset();
        ByteBuffer buf = encoder.encode(CharBuffer.wrap(text));
        int size = buf.limit();
        if (terminateWithNull) {
            ret = new byte[size + 1];
            buf.get(ret, 0, size);
            ret[size] = 0;
        } else {
            ret = new byte[size];
            buf.get(ret, 0, size);
        }
        return ret;
    }

    public static String decode(CharsetDecoder decoder, byte[] rawText) throws CharacterCodingException {
        decoder.reset();
        CharBuffer buf = decoder.decode(ByteBuffer.wrap(rawText));
        return buf.toString();
    }
}

