/*
 * Decompiled with CFR 0.152.
 */
package net.moraleboost.tinysegmenter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TinySegmenterConstants {
    public static final int BIAS = -332;
    public static final String[] BC1_KEYS = new String[]{"OH", "II", "HH", "KH"};
    public static final Integer[] BC1_VALS = new Integer[]{-1378, 2461, 6, 406};
    public static final String[] BC2_KEYS = new String[]{"AN", "MK", "HH", "IA", "KI", "KK", "HM", "AA", "HN", "HO", "IH", "II", "IK", "AI", "IO", "MH", "OO"};
    public static final Integer[] BC2_VALS = new Integer[]{-878, 3334, -4070, 1327, 3831, -8741, -1711, -3267, 4012, 3761, -1184, -1332, 1721, 2744, 5492, -3132, -2920};
    public static final String[] BC3_KEYS = new String[]{"MK", "MM", "HH", "HI", "HK", "OA", "KK", "HN", "HO", "IH", "OH"};
    public static final Integer[] BC3_VALS = new Integer[]{1079, 4034, 996, 626, -721, -1652, 2762, -1307, -836, -301, 266};
    public static final String[] BP1_KEYS = new String[]{"BB", "UB", "OB", "OO"};
    public static final Integer[] BP1_VALS = new Integer[]{295, 352, 304, -125};
    public static final String[] BP2_KEYS = new String[]{"BO", "OO"};
    public static final Integer[] BP2_VALS = new Integer[]{60, -1762};
    public static final String[] BQ1_KEYS = new String[]{"BHM", "OHI", "OKH", "OKK", "BII", "BOH", "OIH", "BIM", "BOO", "BMH", "OKA", "OOO", "BHH", "BNH"};
    public static final Integer[] BQ1_VALS = new Integer[]{1521, 451, -1020, 904, -1158, -91, -296, 886, -2597, 1208, 1851, 2965, 1150, 449};
    public static final String[] BQ2_KEYS = new String[]{"BKK", "OHH", "BHM", "BKO", "BIH", "OHM", "OIH", "UHI", "BHH", "BHI"};
    public static final Integer[] BQ2_VALS = new Integer[]{-1720, -1139, 466, 864, -919, -181, 153, -1146, 118, -1159};
    public static final String[] BQ3_KEYS = new String[]{"OHH", "OKH", "OKI", "BNN", "BII", "OHM", "BOH", "OKO", "OII", "BMH", "OMH", "OOO", "BMM", "BHH", "BHI", "BKI"};
    public static final Integer[] BQ3_VALS = new Integer[]{2174, 1798, -793, 998, -299, 439, 775, -2242, 280, 937, -2402, 11699, 8335, -792, 2664, 419};
    public static final String[] BQ4_KEYS = new String[]{"BKK", "OHH", "OHK", "BIH", "BII", "BIK", "ONN", "BOO", "OAH", "BMI", "BHH"};
    public static final Integer[] BQ4_VALS = new Integer[]{-1806, 266, -2036, 3761, -4654, 1348, -973, -12396, 926, -3385, -3895};
    public static final String[] BW1_KEYS = new String[]{"\u5f15\u304d", "\u304b\u3089", "\u3044\u3046", "\u3092\u898b", "\u5e73\u65b9", "B1\u540c", "\u3066\u3044", "\u305f\u3061", "\u5927\u962a", "\uff22\uff11\u3042", "\u307e\u305b", "\u53d6\u308a", "\u306b\u306f", "\u3066\u304d", "\u3059\u3067", "\u6bce\u65e5", "\u3069\u3053", "\u306a\u3093", "\u3055\u3089", "\u3053\u3068", "\u307e\u3067", "\u306e\u4e2d", "\u305d\u3053", "\u3044\u3063", "\u304c\u3089", "\u3068\u307f", "\u3055\u3093", "\u306b\u3082", "\u3063\u305f", "\u306a\u3044", "\u300d\u3068", "\u3064\u3044", "\u305f\u3081", "\u3057\u305f", "\u3046\u3093", "\u672c\u5f53", "\u3067\u304d", "\u3001\u3068", "\u3084\u3080", "\u3088\u3063", "\u307e\u307e", "\u3057\u3066", "\u3001\u540c", "\u306b\u5bfe", "\u4ea1\u304f", "\uff22\uff11\u540c", "\uff63\u3068", "\u3067\u3059", "\u5927\u304d", "B1\u3042", "\u3092\u3057", "\u3042\u3063", "\u307e\u308b", "\u4eac\u90fd", "\u3053\u3093", "\u306a\u3063", "\u3068\u3044", "\u3044\u308b", ",\u3068", "\u308c\u305f", "\u306a\u3069", ",\u540c", "\u306e\u4e00", "\u76ee\u6307", "\u3046\u3057", "\u308c\u3067", "\u3067\u306f", "\u305d\u308c", "\u3053\u3046", "\u306b\u3057", "\u65e5\u672c"};
    public static final Integer[] BW1_VALS = new Integer[]{-1336, 3472, 1743, 731, -2314, 542, 805, 1122, 1497, 1404, 2448, -2784, 1498, 1249, -3399, -2113, 3887, -1113, -4143, 2083, 1711, 741, 1977, -2055, 600, 1922, 4573, 1671, 3463, 5713, 1682, -802, 601, 2641, 665, -2423, 1127, 660, -1947, -2565, 2600, 1104, 727, -912, -1886, 542, 1682, 3445, -2604, 1404, 1860, 1505, -2155, 2558, -1262, 3015, -4915, 672, 660, 2369, 7379, 727, -501, -724, -4817, -913, 844, -871, -790, 2468, -195};
    public static final String[] BW2_KEYS = new String[]{"\u2015\u2015", "\u308c\u3070", "\u3068\u3053", "\u306b\u5bfe", "11", "\u3093\u3060", "\u306f\u3044", "\u304f\u306a", "\u4e00\u90e8", "\u59d4\u54e1", "\u306e\u3067", "\u3067\u3082", "\u3044\u3046", "\u306e\u306b", "\u306f\u304c", "\u3093\u306a", "\u65b0\u805e", "\u3068\u3068", "\u306e\u306e", "\u4f1a\u793e", "\u540c\u515a", "\u3068\u306e", "\u3082\u3044", "\u3081\u3066", "\u3057\u3044", "\u306f\u305a", "\u4e00\u65b9", "\u3092\u901a", "\u5c11\u306a", "\u3057\u304b", "\u4e0a\u304c", "\u3055\u308c", "\u3068\u307f", "\u2212\u2212", "\u3068\u3082", "\u306a\u3044", "\u672c\u4eba", "\u3063\u305f", "\u3055\u3093", "\u306b\u95a2", "\u306a\u304c", "\u3063\u3066", "\u3063\u3068", "\u624b\u6a29", "\u3057\u305f", "\u304b\u3057", "\u3089\u304b", "\u66dc\u65e5", "\u5e74\u5ea6", "\u3057\u3066", "\u305d\u306e", "\u3057\u306a", "\u3082\u306e", "\u4e00\u4eba", "\u6771\u4eac", "\u304c\u3044", "\u3089\u3057", "\u7c73\u56fd", "\u4e00\u65e5", "\u306a\u3069", "\u306b\u304a", "\u3046\u304b", "\u65e5\u7c73", "\u305f\u3044", "\u306a\u306e", "\u3089\u306b", "\u5927\u962a", "\u306b\u3057", "\u5e9c\u770c", "\u304b\u3082", "\u308a\u3057", "\u793e\u4f1a", "\u304b\u3089", "\u307e\u3057", "\u304b\u308c", "\u3070\u308c", "\u3066\u3044", "\u305f\u305f", "\u306b\u306a", "\u305f\u3060", "\u305f\u3061", "\u7b2c\u306b", "\u308f\u308c", "\u3066\u304d", "\u305f\u3068", "\u3066\u304f", "\u306a\u3093", "\u540c\u65e5", "..", "\u307e\u3067", "\u304d\u305f", "\u305f\u306f", "\u3053\u3068", "\u7136\u3068", "\u3053\u306e", "\u304c\u3089", "\u308a\u307e", "\u3067\u3044", "\u306b\u3088", "\uff11\uff11", "\u3067\u304d", "\u306b\u5f93", "\u3066\u306f", "\u7acb\u3066", "\u3067\u3057", "\u3067\u3059", "\u307e\u308c", "\u308c\u305f", "\u3066\u3082", "\u3068\u3044", "\u5206\u306e", "\u306e\u304b", "\u308d\u3046", "\u51fa\u3066", "\u65e5\u672c", "\u308c\u3066", "\u5e74\u9593", "\u65e5\u65b0", "\u671d\u9bae", "\u3055\u305b"};
    public static final Integer[] BW2_VALS = new Integer[]{-5730, 4114, -1746, -14943, -669, 728, 1073, -1597, -1051, -1250, -7059, -4203, -1609, -6041, -1033, -4115, -4066, -2279, -6125, -1116, 970, 720, 2230, -3153, -1819, -2532, -1375, -11877, -1050, -545, -4479, 13168, 5168, -13175, -3941, -2488, -2697, 4589, -3977, -11388, -1313, 1647, -2094, -1982, 5078, -1350, -944, -601, -8669, 972, -3744, 939, -10713, 602, -1543, 853, -1611, -4268, 970, -6509, -1615, 2490, 3372, -1253, 2614, -1897, -2471, 2748, -2363, -602, 651, -1276, -7194, -1316, 4612, 1813, 6144, -662, 2454, -3857, -786, -1612, 7901, 3640, 1224, 2551, 3099, -913, -11822, -6621, 1941, -939, -8392, -1384, -4193, -3198, 1620, 2666, -7236, -669, -1528, -4688, -3110, -990, -3828, -4761, 5409, 4270, -3065, 1890, -7758, 2093, 6067, 2163, -7068, 849, -1626, -722, -2355, 4533};
    public static final String[] BW3_KEYS = new String[]{"\u3067\u306b", "\u5e02", "\u308b\u308b", "\u3067\u306f", "\u308c\u3070", "\u65e5\u3001", "\u305f.", "\u3068\u3057", "\u304c\u3001", "\u3059.", "\u3093\u3060", "\u306b\u3001", "\u3044\u3044", "\u3093\u3067", "\u3069\u3046", "\u3044\u3048", "\u65b0\u805e", "\u305f\u3002", "\u3042\u308a", "\u3042\u308b", "\u3044\u304f", "\u308c\u308b", "\u3068\u306e", "\u3059\u3002", "\u305d\u3046", "\u3057\u3044", "\u3060.", "\u305a,", "\u30ab\u6708", "\u3044\u305f", "\u3044\u3063", "\u5927\u4f1a", "\u3068\u3082", "\u3055\u3092", "\u306a\u3044", "\u3063\u305f", "\u3060\u3002", "\u304b\u3051", "\u3063\u3066", "\u305a\u3001", "\u3057\u305f", "\u306a\u304f", "\u308c,", "\u3057\u3066", "\u3057\u306a", "\u304b\u3063", "\u3089\u3057", "\u3051\u3069", "\uff76\u6708", "\u308c\u3001", "\u304b\u306b", "\u304c\u304d", "\u306e,", "\u306a\u3069", "\u304c\u3051", "\u3044\u308b", "\u305f\u3044", "\u3057\u307e", "\u3044\u308f", "\u4f1a\u8b70", "\u306b\u3057", "\u304c\u3063", "\u306e\u3001", "\u3046\u3061", "\u793e\u4f1a", "\u304b\u3089", "\u304b\u308a", "\u3046\u3068", "\u306e\u5b50", "\u307e\u3057", "\u3066\u3044", "\u306f,", "\u307e\u3059", "\u306b\u306a", "\u3044.", "\u3066\u304a", "\u308f\u308c", "\u306b\u306f", "\u307e\u3063", "\u3089\u308c", "\u307e\u3067", "\u305f\u306e", "\u304d\u305f", "\u3057,", "\u3053\u3068", "\u306f\u3001", "\u3079\u304d", "\u3053\u306e", "\u3044\u3002", "\u304c\u3089", "\u304c\u308a", "\u304b.", "\u3060\u3063", "\u3057\u3001", "\u305f\u308a", "\u305f\u308b", "\u3055\u3044", "\u59cb\u3081", "\u305a\u306b", "\u3059\u308b", "\u3067\u3059", "\u304b\u3002", "\u307e\u308c", "\u65e5,", "\u3053\u308d", "\u3042\u305f", "\u308c\u305f", "\u3048\u3068", "\u304c,", "\u3066\u3082", "\u3068\u3046", "\u308c\u3066", "\u5165\u308a", "\u306b,"};
    public static final Integer[] BW3_VALS = new Integer[]{-1482, 965, 3818, 2295, -3246, 974, 8875, 2266, 1816, -1310, 606, -1021, 5308, 798, 4664, 2079, -5055, 8875, 719, 3846, 3029, 1091, 541, -1310, 428, -3714, 4098, 3426, 990, 2056, 1883, 2217, -3543, 976, 1796, -4748, 4098, -743, 300, 3426, 3562, -903, 854, 1449, 2608, -4098, 1479, 1374, 990, 854, -669, -4855, -724, 2135, -1127, 5600, -594, 1200, 1527, 860, 1771, -913, -724, 1117, 2024, 6520, -2670, 4798, -1000, 1113, 6240, 1337, 6943, 1906, -1185, 855, -605, 2644, -1549, 6820, 6154, 812, 1645, 1557, 7397, 1337, 2181, 1542, -1185, -4977, -2064, 2857, 1004, 1557, -1183, -853, -714, 1681, 841, 6521, 1437, 2857, -793, 974, -2757, -2194, 1850, 1454, 1816, 302, -1387, 1375, 1232, -1021};
    public static final String[] TC1_KEYS = new String[]{"HOM", "MMH", "AAA", "IHI", "OOI", "HHH", "IOH", "HHM", "IOI", "HII", "HOH", "IOM"};
    public static final Integer[] TC1_VALS = new Integer[]{-331, 187, 1093, 1169, -1832, 1029, -142, 580, -1015, 998, -390, 467};
    public static final String[] TC2_KEYS = new String[]{"IHI", "OII", "HMM", "KKH", "HHO", "HII"};
    public static final Integer[] TC2_VALS = new Integer[]{-1965, -2649, -1154, 703, 2088, -1023};
    public static final String[] TC3_KEYS = new String[]{"HHH", "HHI", "KOK", "IOI", "IIH", "AAA", "KKA", "IIM", "MHH", "OHO", "KKH", "KHH", "MHM", "MHO", "IHH", "IHI", "MMH", "IHO", "HOH", "NNH", "HII", "HIK", "NNO"};
    public static final Integer[] TC3_VALS = new Integer[]{346, -341, -1009, -542, -825, -294, 491, -1035, -2694, -3393, -1217, -1216, -457, 123, 128, -3041, -471, -1935, -1486, -1689, -1088, 731, 662};
    public static final String[] TC4_KEYS = new String[]{"MOM", "HHH", "HHI", "HHK", "HHM", "IIH", "HHN", "III", "HHO", "KKA", "IOO", "MHH", "IIO", "MHI", "KKK", "IHH", "MMH", "IHO", "HOH", "MMM", "HIH", "HII", "KAK"};
    public static final Integer[] TC4_VALS = new Integer[]{841, -203, 1344, 365, -122, 321, 182, 1497, 669, 3386, 54, -405, 656, 201, 3065, 695, -241, -2324, 446, 661, 804, 679, 4845};
    public static final String[] TQ1_KEYS = new String[]{"BHIH", "OHHH", "BOHH", "OIIH", "BNHH", "OHIH", "BIHH", "BHHH", "BHHI", "OAKK", "BIII", "BOOO", "OIHI"};
    public static final Integer[] TQ1_VALS = new Integer[]{-132, 281, 225, -68, -744, 249, 60, -227, 316, 482, 1595, -908, 200};
    public static final String[] TQ2_KEYS = new String[]{"BIHH", "BKAK", "BOOO", "BIII"};
    public static final Integer[] TQ2_VALS = new Integer[]{-1401, -543, -5591, -1033};
    public static final String[] TQ3_KEYS = new String[]{"BHIH", "BHII", "OHII", "OKAK", "OOII", "BHHH", "OHHH", "OHHI", "BHHM", "BIIH", "BIII", "OIIH", "OOHH", "OKKA", "BMHI", "BMHM", "OHMH", "OKHH", "BOMH", "OIHH"};
    public static final Integer[] TQ3_VALS = new Integer[]{222, -504, 997, 2792, -685, 478, 346, 1729, -1073, -116, -105, 1344, 110, 679, -863, -464, 481, 587, 620, 623};
    public static final String[] TQ4_KEYS = new String[]{"BHII", "OHHH", "OHHI", "OKAK", "OIIH", "OIII", "OHHO", "OHIH", "BHHH", "OAKK", "BIIH", "BIII", "OAAA", "OIHH", "BHHM", "OIHI"};
    public static final Integer[] TQ4_VALS = new Integer[]{-966, -294, 2446, -8156, 626, -4007, 480, -1573, -721, 180, -607, -2181, -2763, 1935, -3604, -493};
    public static final String[] TW1_KEYS = new String[]{"\u6771\u4eac\u90fd", "\u306b\u3064\u3044"};
    public static final Integer[] TW1_VALS = new Integer[]{2026, -4681};
    public static final String[] TW2_KEYS = new String[]{"\u3060\u3063\u3066", "\u3057\u3087\u3046", "\u3068\u3057\u3066", "\u3042\u308b\u7a0b", "\u5927\u304d\u306a", "\u305d\u306e\u5f8c", "\u3068\u3082\u306b", "\u3053\u308d\u304c", "\u5bfe\u3057\u3066", "\u3082\u306e\u3067", "\u793e\u4f1a\u515a", "\u3066\u3044\u305f", "\u4e00\u6c17\u306b", "\u3044\u3063\u305f", "\u521d\u3081\u3066", "\u540c\u6642\u306b"};
    public static final Integer[] TW2_VALS = new Integer[]{-1049, 3873, -4657, -2049, -1255, -4430, -4517, -2434, -2721, 1882, -3216, 1833, -792, -1256, -1512, -8097};
    public static final String[] TW3_KEYS = new String[]{"\u306e\u3067\u3001", "\u3068\u3057\u3066", "\u306e\u3082\u306e", "\u306b\u3068\u3063", "\u3044\u305f\u3060", "\u306b\u3064\u3044", "\u3057\u3066\u3044", "\u306e\u3067,", "\u5341\u4e8c\u6708", "\u308c\u304b\u3089", "\u306b\u5f53\u305f"};
    public static final Integer[] TW3_VALS = new Integer[]{-727, -4314, -600, -5989, -1734, -5483, 1314, -727, -2287, -3752, -6247};
    public static final String[] TW4_KEYS = new String[]{"\u304b\u3089\u306a", "\u307e\u3057\u305f", "\u3068\u3044\u3046", "\u3044\u3046.", "\u3088\u3046\u3068", "\u3088\u308b\u3068", "\u305f\u304c,", "\u3066\u3044\u308b", "\u3057\u3066\u3044", "\u3044\u3046\u3002", "\u307e\u305b\u3093", "\u305f\u304c\u3001"};
    public static final Integer[] TW4_VALS = new Integer[]{-2348, 5543, 1349, 8576, -4258, 5865, 1516, 1538, 2958, 8576, 1097, 1516};
    public static final String[] UC1_KEYS = new String[]{"M", "O", "K", "A"};
    public static final Integer[] UC1_VALS = new Integer[]{645, -505, 93, 484};
    public static final String[] UC2_KEYS = new String[]{"M", "N", "O", "H", "I", "A"};
    public static final Integer[] UC2_VALS = new Integer[]{3987, 5775, 646, 1059, 409, 819};
    public static final String[] UC3_KEYS = new String[]{"A", "I"};
    public static final Integer[] UC3_VALS = new Integer[]{-1370, 2311};
    public static final String[] UC4_KEYS = new String[]{"M", "N", "O", "H", "I", "K", "A"};
    public static final Integer[] UC4_VALS = new Integer[]{3565, 3876, 6646, 1809, -1032, -3450, -2643};
    public static final String[] UC5_KEYS = new String[]{"M", "O", "H", "I", "K"};
    public static final Integer[] UC5_VALS = new Integer[]{539, -831, 313, -1238, -799};
    public static final String[] UC6_KEYS = new String[]{"M", "O", "H", "I", "K"};
    public static final Integer[] UC6_VALS = new Integer[]{247, -387, -506, -253, 87};
    public static final String[] UP1_KEYS = new String[]{"O"};
    public static final Integer[] UP1_VALS = new Integer[]{-214};
    public static final String[] UP2_KEYS = new String[]{"B", "O"};
    public static final Integer[] UP2_VALS = new Integer[]{69, 935};
    public static final String[] UP3_KEYS = new String[]{"B"};
    public static final Integer[] UP3_VALS = new Integer[]{189};
    public static final String[] UQ1_KEYS = new String[]{"BH", "BI", "BK", "BN", "BO", "OH", "OI", "OK", "OO"};
    public static final Integer[] UQ1_VALS = new Integer[]{21, -12, -99, 142, -56, -95, 477, 410, -2422};
    public static final String[] UQ2_KEYS = new String[]{"BH", "BI", "OK"};
    public static final Integer[] UQ2_VALS = new Integer[]{216, 113, 1759};
    public static final String[] UQ3_KEYS = new String[]{"BH", "BI", "BK", "BM", "BN", "BO", "OI", "BA", "ON"};
    public static final Integer[] UQ3_VALS = new Integer[]{42, 1913, -7198, 3160, 6427, 14761, -827, -479, -3212};
    public static final String[] UW1_KEYS = new String[]{"\u4eac", "\u3042", "\u59d4", "\u3046", "\u304c", "\u304d", "\uff62", "\u3053", "\uff65", "\u5927", "\u533a", "\u5e02", "\u3001", "\u56fd", "\u5348", "\u3067", "\u3068", "\u3069", ",", "\u306b", "\u300c", "\u306e", "\u306f", "\u65e5", "\u751f", "\u7406", "\u90fd", "\u3082", "\u3084", "\u3088", "\u3089", "\u770c", "\u308a", "\u4e3b", "\u308c", "\u3092", "\u3093", "\u30fb"};
    public static final Integer[] UW1_VALS = new Integer[]{-268, -941, 729, -127, -553, 121, -463, 505, -135, 561, -912, -411, 156, -460, 871, -201, -547, -123, 156, -789, -463, -185, -847, -141, -408, 361, -718, -466, -470, 182, -292, -386, 208, -402, 169, -446, -137, -135};
    public static final String[] UW2_KEYS = new String[]{"\u63fa", "\u5e02", "\u3082", "\u4f1a", "\u3084", "\u4fdd", "\u3088", "\u6700", "\u308a", "\u521d", "\u308b", "\u308c", "\u6587", "\u7b2c", "\u5165", "\u3092", "\u3093", "\u81ea", "\u30a2", "\u671d", ",", "\u30ab", "\u30ad", "\u4e8b", "\u672c", "\u897f", "\u65b0", "\uff62", "\uff63", "\u3001", "\u898b", "\u30c3", "\uff6f", "\u5317", "\u3007", "\uff71", "\u5c0f", "\u5b50", "\u300c", "\uff76", "\u300d", "\u76ee", "\uff77", "\u958b", "\u76f8", "\u9593", "\u526f", "\u5927", "\u5b66", "\u5929", "\u592a", "\u7406", "\u4eba", "\u533a", "\u770c", "\u65e5", "\u7acb", "\u6b21", "\u4e09", "\u5e74", "\u4e0d", "\u5f37", "\u6771", "\u8fbc", "\u4e16", "\u3042", "\u884c", "\u3044", "\u3046", "\u653f", "\u304a", "\u304b", "\u304c", "\u624b", "\u304f", "\u3053", "\u4e2d", "\u3055", "\u3056", "\u660e", "\u3057", "\u767a", "\u5b9f", "\u3059", "\u7c73", "\u305b", "\u305d", "\u305f", "\u3060", "\u6c11", "\u4e3b", "\u3064", "\u3066", "\u679c", "\u3067", "\u6c17", "\u3068", "\u3069", "\u306a", "\u8b70", "\u306b", "\u306e", "\u306f", "\u3072", "\u8abf", "\u3079", "\u307e"};
    public static final Integer[] UW2_VALS = new Integer[]{-1033, -813, -1263, 978, -402, 362, 1639, -630, -579, -3025, -694, 571, -1355, 810, 548, -2516, 2095, -1353, -587, -1843, -829, 306, 568, 492, -1650, -744, -1682, -645, 3145, -829, -3874, 831, 831, -3414, 892, -587, -2009, -1519, -645, 306, 3145, -1584, 568, 1758, -242, -1257, -1566, -1769, 760, -865, -483, 752, -123, -422, -1165, -1815, -763, -2378, -758, -1060, -2150, 1067, -931, 3041, -302, -538, 838, 505, 134, 1522, -502, 1454, -856, -1519, -412, 1141, -968, 878, 540, -1462, 1529, 529, 1023, -675, 509, 300, -1011, 188, 1837, -180, -861, -949, -291, -665, -268, -1740, -981, 1273, 1063, 1198, -1764, 130, -409, -1273, 1010, 1261, 600};
    public static final String[] UW3_KEYS = new String[]{"1", "\u4f4e", "\u524d", "\u95a2", "\u4f55", "\u4f5c", "\u674e", "\u6751", "\u8cbb", "\u53e3", "\u8fbc", "\u7acb", "\u3001", "\u5b66", "\u7dcf", "\u3005", "\u526f", "\u3007", "\u65e5", "\u65e7", "\u53f3", ",", "\u300d", "\u7dda", "\u5e73", "\u5e74", "\u3013", "\u4e00", "\u68ee", "\u77e5", "\u6771", "\u56fd", "\u5404", "\u4e0b", "\u5408", "\u6d77", "\u5e83", "\u975e", "\u540c", "\u5b89", "\u7c73", "\u6307", "\u4e16", "\u529b", "\u7684", "\u80fd", "\u4e21", "\u6c0f", "\u6c11", "\u5e9c", "\u5b9f", "\u601d", "\u4e2d", "\u3042", "\u3044", "\u5ea6", "\u3046", "\u6027", "\u3048", "\u304a", "\u304b", "\u6628", "\u304c", "\u751f", "\u4e3b", "\u304f", "\u3051", "\u3052", "\u5bb6", "\u3053", "\u3054", "\u3055", "\u7528", "\u3057", "\u5143", "\u3059", "\u901a", "\u305b", "\u305d", "\u7b2c", "\uff78\uff9e", "\u305f", "\u3061", "\u3063", "\u3064", "\u3066", "\u6642", "\u3067", "\u3068", "\u753a", "\u3069", "\u306a", "\u306b", "\u52d5", "\u306e", "\u306f", "\u52d9", "\u515a", "\u3072", "\u4fdd", "\u79c1", "\u3075", "\u3078", "\u307b", "\u307e", "\u5168", "\u307f", "\u3081", "\u516c", "\u3082", "\u516d", "\u3084", "\u5171", "\u3088", "\u3089", "\u8eca", "\u308a", "\u308b", "\u308c", "\u8ecd", "\u308f", "\u3092", "\u91d1", "\u3093", "\u696d", "\u7269", "\u5efa", "\uff11", "\u5186", "\u4e88", "\u4e8c", "\u30a2", "\u6c7a", "\u518d", "\u76f4", "\u548c", "\u578b", "\u7279", "\u82f1", "\u5c0f", "\u5316", "\u5c11", "\u5317", "\u7cfb", "\u30b0", "\u7701", "\u5916", "\u7d04", "\u9078", "\u30b9", "\u8005", "\u770c", "\u7a0e", "\u30c3", "\u30c8", "\u7121", "\u7d1a", "\u4eba", "\u533a", "\u6238", "\u5343", "\u6838", "\u4eca", "\u5348", "\u30e0", "\u653f", "\u4ed6", "\u5354", "\u30eb", "\u30ed", "\uff63", "\uff65", "\u5f53", "\u30f3", "\u54e1", "\u4ee5", "\uff6f", "\u30fb", "\u8abf", "\uff71", "\u6559", "\u5dde", "\u6cd5", "\u66dc", "\uff7d", "\u2212", "\u99c5", "\u90ce", "\uff84", "\u6570", "\uff91", "\u5206", "\u5e02", "\u81ea", "\u90e1", "\uff99", "\u6700", "\u7d71", "\uff9b", "\uff9d", "\u90e8", "\u6587", "\u6708", "\u96e8", "\u521d", "\u5f97", "\u9577", "\u5225", "\u96fb", "\u671f", "\u898b", "\u5834", "\u958b", "\u65b0", "\u59bb", "\u9593", "\u8ca1"};
    public static final Integer[] UW3_VALS = new Integer[]{-800, 811, 2286, -1282, 4265, -361, 3094, 364, 1777, 483, -1504, -960, 4889, -1356, 1163, -2311, 4437, 5827, 2099, 5792, 1233, 4889, 2670, 1255, -1804, 2416, -3573, -1619, 2438, -1528, -805, 642, 3588, -1759, -241, -495, -1030, 2066, 3906, -423, 7767, -3973, -2087, 365, 7313, 725, 3815, 2613, -1694, 1605, -1008, -1291, 653, -2696, 1006, 1452, 2342, 1822, 1983, -4864, -1163, -661, 3271, -273, -758, 1004, 388, 401, 1078, -3552, -3116, -1058, 914, -395, 4858, 584, -1136, 3685, -5228, 1201, 1319, 842, -521, -1444, -1081, 6167, -1248, 2318, 1691, 1215, -899, -2788, 2745, -949, 4056, 4555, -1872, 3593, -2171, -2439, 4231, -1798, 1199, -5516, -4384, 1574, -120, 1205, -3030, 2323, 755, -788, -1880, -202, 727, 1835, 649, 5905, 2773, 1375, -1207, 6620, 2163, -518, 484, 461, -2352, -800, 5807, -1193, 974, 551, -1073, 3095, -1835, -837, 1389, -3850, 785, -513, 1327, -3102, -1038, 3066, 1319, 792, -241, 3663, -681, 874, 6457, 6293, 401, -1350, 521, 979, 1384, 2742, 4646, -488, -2309, 5156, 792, -783, 1109, -2013, 1889, -1006, 1591, 2201, 2670, -3794, -3885, 278, 4513, -1368, -1350, -3794, -562, 551, -1479, 1155, 1868, -951, 874, -1723, 1620, 1026, 521, 3222, 1109, 457, 3197, -2869, 4404, 1591, -937, -4229, 2201, 278, 1200, -1489, 4125, 2009, 2475, 1905, 421, 1129, -1045, 360, 1044, 1219, -1432, 1764, 2016, 1302, -733};
    public static final String[] UW4_KEYS = new String[]{"\u822c", "\u524d", "\u4f53", "\u5b50", "\u4f5c", "\u56de", "\u8fbc", "\u7acb", "\u3001", "\u3002", "\u5b66", "\u7dcf", "\u526f", "\u3007", "\u884c", "\u65e5", "\u6765", "\u300c", ",", "\u300d", ".", "\u7dda", "\u8fd1", "\u5e74", "\u3013", "\u5cf6", "\u4e00", "\u56fd", "\u8cde", "\u5e81", "\u5408", "\u8b66", "\u7c73", "\u7f72", "\u5712", "\u8b70", "\u529b", "\u7684", "\u80fd", "\u7387", "\u5b9a", "\u6c0f", "\u6c11", "\u6c17", "\u4e2d", "\u3042", "\u3044", "\u3046", "\u6027", "\u3048", "\u5730", "\u304a", "\u304b", "\u304c", "\u304d", "\u751f", "\u304e", "\u304f", "\u3051", "\u7523", "\u3052", "\u3053", "\u3054", "\u3055", "\u3057", "\u3058", "\u3059", "\u305a", "\u305b", "\u305d", "\u5148", "\u7530", "\u7b2c", "\u305f", "\u3060", "\u3061", "\u3063", "\u3064", "\u3066", "\u6642", "\u3067", "\u3068", "\u753a", "\u306a", "\u306b", "\u306c", "\u52d5", "\u306d", "\u306e", "\u9928", "\u306f", "\u3070", "\u52d9", "\u515a", "\u3072", "\u3073", "\u3075", "\u3078", "\u3079", "\u307b", "\u307e", "\u307f", "\u3080", "\u3081", "\u3082", "\u3083", "\u3084", "\u58eb", "\u5171", "\u3087", "\u3088", "\u3089", "\u8eca", "\u308a", "\u2015", "\u308b", "\u308c", "\u8ecd", "\u308d", "\u308f", "\u91ce", "\u3092", "\u3093", "\u696d", "\u9053", "\u7269", "\u5bfa", "\u5185", "\u5186", "\u4e88", "\u76ee", "\u4e8b", "\u9ad8", "\u548c", "\u9662", "\u4e95", "\u30ab", "\u5c0f", "\u5316", "\u7cfb", "\u7403", "\u7701", "\u6e08", "\u30b3", "\u591a", "\u7d04", "\u9078", "\u8005", "\u30bb", "\u770c", "\u5927", "\u30c3", "\u6821", "\u30c8", "\u6ca2", "\u4eba", "\u533a", "\u652f", "\u6539", "\u9996", "\u9818", "\u969b", "\u6240", "\u30e1", "\u653f", "\u5c4b", "\u30e9", "\u8f2a", "\u30ea", "\u5354", "\u30eb", "\uff62", "\uff63", "\uff65", "\u30f3", "\u8c37", "\u54e1", "\u4ee5", "\uff6f", "\uff70", "\u5ddd", "\u30fb", "\u6559", "\u30fc", "\u7d4c", "\uff76", "\u5668", "\uff7a", "\uff7e", "\u5074", "\u5c71", "\u90ce", "\uff84", "\u984c", "\uff92", "\u5e02", "\uff97", "\uff98", "\uff99", "\u6700", "\u7d71", "\uff9d", "\u6587", "\u5f8c", "\u7a7a", "\u6708", "\u4f1a", "\u521d", "\u9577", "\u90fd", "\u611f", "\u96fb", "\u9280", "\u898f", "\u6728", "\u5834", "\u9593", "\u53c2", "\u5841", "\u65b9"};
    public static final Integer[] UW4_VALS = new Integer[]{-852, 1623, -1286, -4802, 530, 1500, -3370, -2112, 3930, 3508, -1397, 940, 3879, 4999, -792, 1798, -442, 1895, 3930, 3798, 3508, -994, 929, 374, -5156, -2056, -2069, -619, 730, -4556, -1834, -1184, 2937, 749, -1200, -244, -302, 2586, -730, 672, -1057, 5388, -2716, -910, 2210, 4752, -3435, -640, 553, -2514, 866, 2405, 530, 6006, -4482, -1286, -3821, -3788, -4376, -1101, -4734, 2255, 1979, 2864, -843, -2506, -731, 1251, 181, 4091, 601, -2900, 788, 5034, 5408, -3654, -5882, -1659, 3994, 1829, 7410, 4547, 1826, 5433, 6499, 1853, -740, 1413, 7396, -1984, 8578, 1940, -2715, -2006, 4249, -4134, 1345, 6665, -744, 1464, 1051, -2082, -882, -5046, 4169, -2666, 2795, -1413, -1212, -1544, 3351, -2922, -1481, -9726, -4841, -14896, -2613, 1158, -4570, -1783, -1100, 13150, -2352, -1043, -1291, -735, -809, 584, 788, 782, 922, -190, 2120, -681, -2297, -1768, 2145, 1910, 776, 786, -1267, -3485, -543, 1789, 1067, 2171, 2596, 2145, 1287, 2997, 571, -724, -360, -403, -939, 1036, 4517, 856, 787, 1749, -1659, -2604, -1566, -1635, 2182, -1328, -881, -1433, -541, 1013, -856, 1895, 3798, -4371, -3637, -1000, -910, 544, -724, -11870, -2667, -4371, 704, -11870, 1146, 2145, -851, 1789, 1287, 4292, -1500, -4866, -403, -792, -1635, 2771, -881, -541, -856, 845, -1169, -3637, 522, 456, -867, -9066, 950, 1347, 357, 1192, 916, -878, -2213, 792, -485, -1410, -2344, 1555, -2094, -856};
    public static final String[] UW5_KEYS = new String[]{"\u307f", "\u5e02", "1", "\u3081", "\u3083", "\u4f1a", "\u515a", "\u3087", "\u52d9", "\u308a", "\u308b", "\uff25\uff12", "\u308c", "\u5d50", "\u7530", "\u308f", "\u90ce", "\u6708", "\u3092", "\u3093", "\u753a", "\u984c", "\u7d71", "\u7a7a", "\u30a4", "\u5e2d", ",", ".", "\u9928", "\u65b0", "\uff62", "\u9577", "\u3001", "\u3002", "\u67fb", "\uff72", "\u300c", "\u4eac", "\u76f8", "E2", "\u9593", "]", "\u5927", "\u5b66", "\u7701", "\u793e", "\u533a", "\u770c", "\u30eb", "\u65e5", "\u6a5f", "\uff99", "\u8005", "\u5e74", "\uff9d", "\u30f3", "\u9078", "\u3042", "\u6240", "\u3044", "\u3046", "\u683c", "\u3048", "\u304a", "\u304b", "\u304c", "\u304d", "\u304e", "\u304f", "\u54e1", "\u3052", "\u5b9a", "\u4e2d", "\u3055", "\u3057", "\u8a9e", "\u3059", "\u6319", "\u601d", "\u8868", "\u6c0f", "\u3060", "\u3061", "\u7684", "\u3063", "\u3064", "\u3066", "\uff11", "\u3067", "\u3068", "\u3069", "\u306a", "\u8b70", "\u306b", "\u306e", "\u306f", "\u7814", "\u3079", "\u544a"};
    public static final Integer[] UW5_VALS = new Integer[]{502, -2991, -514, 865, 3350, -1153, -654, 854, 3519, -208, 429, Short.MIN_VALUE, 504, -1304, 240, 419, -368, -4353, -1264, 327, -3912, 2368, 1955, -813, 241, 921, 465, -299, -689, -1682, 363, 786, 465, -299, 932, 241, 363, 722, 1319, Short.MIN_VALUE, 1191, -2762, -1296, -548, -1052, -278, -901, -4003, 451, 218, -1508, 451, -2233, 1763, -343, -343, -1018, 1655, -814, 331, -503, 1356, 1199, 527, 647, -421, 1624, 1971, 312, 2104, -983, 1785, -871, -1537, -1371, -1073, -852, 1618, 872, 663, -1347, -1186, 1093, -3149, 52, 921, -18, -514, -850, -127, 1682, -787, 1219, -1224, -635, -578, -997, 1001, 848};
    public static final String[] UW6_KEYS = new String[]{"1", "E1", "\u3042", "\u7a7a", "\u59d4", "\u3046", "\u696d", "\u304b", "\u304c", "\u4f1a", "\u304f", "\u4e00", "\u90ce", "\u3053", "\u3058", "\u533a", "\u3059", "\u5b66", "\uff25\uff11", "\u5e02", "\uff11", "\u305f", "\u3001", "\u3002", "\u3063", "\u9023", "\u3066", "\u3067", "\u3068", ",", "\u306a", "\u306b", "\u5f8c", ".", "\u306e", "\u306f", "\u798f", "\u76f8", "\u4e2d", "\u5e83", "\u3082", "\u793e", "\u54e1", "\uff99", "\u524d", "\u4ef6", "\u308a", "\u308b", "\uff9d", "\u30eb", "\u3092", "\u30f3", "\u8005"};
    public static final Integer[] UW6_VALS = new Integer[]{-270, 306, -307, -822, 798, 189, -697, 241, -73, 624, -121, -277, 1082, -200, 1782, 1792, 383, -960, 306, 887, -270, -428, 227, 808, 573, 463, -1014, 101, -105, 227, -253, -149, 535, 808, -417, -236, 974, 753, 201, -695, -206, -507, -1212, -673, 302, -800, 187, -135, -496, -673, 195, -496, 1811};
    public static final Map<String, Integer> BC1;
    public static final Map<String, Integer> BC2;
    public static final Map<String, Integer> BC3;
    public static final Map<String, Integer> BP1;
    public static final Map<String, Integer> BP2;
    public static final Map<String, Integer> BQ1;
    public static final Map<String, Integer> BQ2;
    public static final Map<String, Integer> BQ3;
    public static final Map<String, Integer> BQ4;
    public static final Map<String, Integer> BW1;
    public static final Map<String, Integer> BW2;
    public static final Map<String, Integer> BW3;
    public static final Map<String, Integer> TC1;
    public static final Map<String, Integer> TC2;
    public static final Map<String, Integer> TC3;
    public static final Map<String, Integer> TC4;
    public static final Map<String, Integer> TQ1;
    public static final Map<String, Integer> TQ2;
    public static final Map<String, Integer> TQ3;
    public static final Map<String, Integer> TQ4;
    public static final Map<String, Integer> TW1;
    public static final Map<String, Integer> TW2;
    public static final Map<String, Integer> TW3;
    public static final Map<String, Integer> TW4;
    public static final Map<String, Integer> UC1;
    public static final Map<String, Integer> UC2;
    public static final Map<String, Integer> UC3;
    public static final Map<String, Integer> UC4;
    public static final Map<String, Integer> UC5;
    public static final Map<String, Integer> UC6;
    public static final Map<String, Integer> UP1;
    public static final Map<String, Integer> UP2;
    public static final Map<String, Integer> UP3;
    public static final Map<String, Integer> UQ1;
    public static final Map<String, Integer> UQ2;
    public static final Map<String, Integer> UQ3;
    public static final Map<String, Integer> UW1;
    public static final Map<String, Integer> UW2;
    public static final Map<String, Integer> UW3;
    public static final Map<String, Integer> UW4;
    public static final Map<String, Integer> UW5;
    public static final Map<String, Integer> UW6;

    /*
     * Opcode count of 13322 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        int i = 0;
        while (i < BC1_KEYS.length) {
            m.put(BC1_KEYS[i], BC1_VALS[i]);
            ++i;
        }
        BC1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BC2_KEYS.length) {
            m.put(BC2_KEYS[i], BC2_VALS[i]);
            ++i;
        }
        BC2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BC3_KEYS.length) {
            m.put(BC3_KEYS[i], BC3_VALS[i]);
            ++i;
        }
        BC3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BP1_KEYS.length) {
            m.put(BP1_KEYS[i], BP1_VALS[i]);
            ++i;
        }
        BP1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BP2_KEYS.length) {
            m.put(BP2_KEYS[i], BP2_VALS[i]);
            ++i;
        }
        BP2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BQ1_KEYS.length) {
            m.put(BQ1_KEYS[i], BQ1_VALS[i]);
            ++i;
        }
        BQ1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BQ2_KEYS.length) {
            m.put(BQ2_KEYS[i], BQ2_VALS[i]);
            ++i;
        }
        BQ2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BQ3_KEYS.length) {
            m.put(BQ3_KEYS[i], BQ3_VALS[i]);
            ++i;
        }
        BQ3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BQ4_KEYS.length) {
            m.put(BQ4_KEYS[i], BQ4_VALS[i]);
            ++i;
        }
        BQ4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BW1_KEYS.length) {
            m.put(BW1_KEYS[i], BW1_VALS[i]);
            ++i;
        }
        BW1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BW2_KEYS.length) {
            m.put(BW2_KEYS[i], BW2_VALS[i]);
            ++i;
        }
        BW2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < BW3_KEYS.length) {
            m.put(BW3_KEYS[i], BW3_VALS[i]);
            ++i;
        }
        BW3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TC1_KEYS.length) {
            m.put(TC1_KEYS[i], TC1_VALS[i]);
            ++i;
        }
        TC1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TC2_KEYS.length) {
            m.put(TC2_KEYS[i], TC2_VALS[i]);
            ++i;
        }
        TC2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TC3_KEYS.length) {
            m.put(TC3_KEYS[i], TC3_VALS[i]);
            ++i;
        }
        TC3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TC4_KEYS.length) {
            m.put(TC4_KEYS[i], TC4_VALS[i]);
            ++i;
        }
        TC4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TQ1_KEYS.length) {
            m.put(TQ1_KEYS[i], TQ1_VALS[i]);
            ++i;
        }
        TQ1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TQ2_KEYS.length) {
            m.put(TQ2_KEYS[i], TQ2_VALS[i]);
            ++i;
        }
        TQ2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TQ3_KEYS.length) {
            m.put(TQ3_KEYS[i], TQ3_VALS[i]);
            ++i;
        }
        TQ3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TQ4_KEYS.length) {
            m.put(TQ4_KEYS[i], TQ4_VALS[i]);
            ++i;
        }
        TQ4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TW1_KEYS.length) {
            m.put(TW1_KEYS[i], TW1_VALS[i]);
            ++i;
        }
        TW1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TW2_KEYS.length) {
            m.put(TW2_KEYS[i], TW2_VALS[i]);
            ++i;
        }
        TW2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TW3_KEYS.length) {
            m.put(TW3_KEYS[i], TW3_VALS[i]);
            ++i;
        }
        TW3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < TW4_KEYS.length) {
            m.put(TW4_KEYS[i], TW4_VALS[i]);
            ++i;
        }
        TW4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UC1_KEYS.length) {
            m.put(UC1_KEYS[i], UC1_VALS[i]);
            ++i;
        }
        UC1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UC2_KEYS.length) {
            m.put(UC2_KEYS[i], UC2_VALS[i]);
            ++i;
        }
        UC2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UC3_KEYS.length) {
            m.put(UC3_KEYS[i], UC3_VALS[i]);
            ++i;
        }
        UC3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UC4_KEYS.length) {
            m.put(UC4_KEYS[i], UC4_VALS[i]);
            ++i;
        }
        UC4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UC5_KEYS.length) {
            m.put(UC5_KEYS[i], UC5_VALS[i]);
            ++i;
        }
        UC5 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UC6_KEYS.length) {
            m.put(UC6_KEYS[i], UC6_VALS[i]);
            ++i;
        }
        UC6 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UP1_KEYS.length) {
            m.put(UP1_KEYS[i], UP1_VALS[i]);
            ++i;
        }
        UP1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UP2_KEYS.length) {
            m.put(UP2_KEYS[i], UP2_VALS[i]);
            ++i;
        }
        UP2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UP3_KEYS.length) {
            m.put(UP3_KEYS[i], UP3_VALS[i]);
            ++i;
        }
        UP3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UQ1_KEYS.length) {
            m.put(UQ1_KEYS[i], UQ1_VALS[i]);
            ++i;
        }
        UQ1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UQ2_KEYS.length) {
            m.put(UQ2_KEYS[i], UQ2_VALS[i]);
            ++i;
        }
        UQ2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UQ3_KEYS.length) {
            m.put(UQ3_KEYS[i], UQ3_VALS[i]);
            ++i;
        }
        UQ3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UW1_KEYS.length) {
            m.put(UW1_KEYS[i], UW1_VALS[i]);
            ++i;
        }
        UW1 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UW2_KEYS.length) {
            m.put(UW2_KEYS[i], UW2_VALS[i]);
            ++i;
        }
        UW2 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UW3_KEYS.length) {
            m.put(UW3_KEYS[i], UW3_VALS[i]);
            ++i;
        }
        UW3 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UW4_KEYS.length) {
            m.put(UW4_KEYS[i], UW4_VALS[i]);
            ++i;
        }
        UW4 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UW5_KEYS.length) {
            m.put(UW5_KEYS[i], UW5_VALS[i]);
            ++i;
        }
        UW5 = Collections.unmodifiableMap(m);
        m = new HashMap();
        i = 0;
        while (i < UW6_KEYS.length) {
            m.put(UW6_KEYS[i], UW6_VALS[i]);
            ++i;
        }
        UW6 = Collections.unmodifiableMap(m);
    }
}

