/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SVNSocketConnection
implements Runnable {
    private Socket mySocket;
    private InetSocketAddress myAddress;
    private int myTimeout;
    private IOException myError;
    private volatile boolean myIsSocketConnected;

    public SVNSocketConnection(Socket socket, InetSocketAddress address, int timeout) {
        this.mySocket = socket;
        this.myAddress = address;
        this.myTimeout = timeout;
        this.myIsSocketConnected = false;
    }

    public IOException getError() {
        return this.myError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSocketConnected() {
        SVNSocketConnection sVNSocketConnection = this;
        synchronized (sVNSocketConnection) {
            if (!this.myIsSocketConnected) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.myIsSocketConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        SVNSocketConnection sVNSocketConnection;
        try {
            try {
                this.mySocket.connect(this.myAddress, this.myTimeout);
            }
            catch (IOException e) {
                this.myError = e;
                Object var3_2 = null;
                SVNSocketConnection sVNSocketConnection3 = this;
                synchronized (sVNSocketConnection3) {
                    this.myIsSocketConnected = true;
                    this.notify();
                    return;
                }
            }
            Object var3_1 = null;
            sVNSocketConnection = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            SVNSocketConnection sVNSocketConnection2 = this;
            synchronized (sVNSocketConnection2) {
                this.myIsSocketConnected = true;
                this.notify();
                throw throwable;
            }
        }
        synchronized (sVNSocketConnection) {
            this.myIsSocketConnected = true;
            this.notify();
            return;
        }
    }
}

