/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat;

import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Properties;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.silvestrislab.cyclotis.omegat.HttpCyclotis;

public abstract class HttpCyclotisTMX<T extends PrepareTMXEntry>
extends HttpCyclotis<T> {
    public static final int COL_AUTHOR = 2;
    public static final int COL_DATE = 3;
    public static final int COL_CHANGER = 4;
    public static final int COL_CHANGEDATE = 5;
    public static final int COL_PROPS = 6;
    public static final int COL_NOTE = 7;
    private String author;

    protected HttpCyclotisTMX(Properties propList) {
        super(propList);
        this.author = propList.getProperty("author");
        if (this.author == null) {
            this.author = Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name"));
        }
    }

    protected void fillEntry(T entry, String[] cols) {
        try {
            ((PrepareTMXEntry)entry).source = this.reformatText(URLDecoder.decode(cols[0]), true);
            ((PrepareTMXEntry)entry).translation = this.reformatText(URLDecoder.decode(cols[1]), true);
            ((PrepareTMXEntry)entry).creator = URLDecoder.decode(cols[2]);
            ((PrepareTMXEntry)entry).creationDate = this.PSQL_DATE.parse(cols[3]).getTime();
            ((PrepareTMXEntry)entry).changer = URLDecoder.decode(cols[4]);
            ((PrepareTMXEntry)entry).changeDate = this.PSQL_DATE.parse(cols[5]).getTime();
            ((PrepareTMXEntry)entry).note = URLDecoder.decode(cols[7]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cols[6].contains("=")) {
            String[] propsCol = cols[6].split("&");
            ((PrepareTMXEntry)entry).otherProperties = new ArrayList(propsCol.length);
            for (int i = 0; i < propsCol.length; ++i) {
                String[] keyVal = propsCol[i].split("=");
                if (i == 0) {
                    keyVal[0] = keyVal[0].substring(1);
                }
                if (i == propsCol.length - 1) {
                    keyVal[1] = keyVal[1].substring(0, keyVal[1].length() - 1);
                }
                keyVal[0] = URLDecoder.decode(keyVal[0]);
                keyVal[1] = URLDecoder.decode(keyVal[1]);
                ((PrepareTMXEntry)entry).otherProperties.add(new TMXProp(keyVal[0], keyVal[1]));
            }
        }
    }

    @Override
    protected String encodeArgs(T entry) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append(HttpCyclotisTMX.encodeArg("src", this.reformatText(((PrepareTMXEntry)entry).source, false))).append("&");
        buf.append(HttpCyclotisTMX.encodeArg("tra", this.reformatText(((PrepareTMXEntry)entry).translation, false))).append("&");
        buf.append(HttpCyclotisTMX.encodeArg("author", Preferences.getPreferenceDefault((String)"team_Author", (String)System.getProperty("user.name")))).append("&");
        if (((PrepareTMXEntry)entry).note != null) {
            buf.append(HttpCyclotisTMX.encodeArg("note", ((PrepareTMXEntry)entry).note));
        }
        if (((PrepareTMXEntry)entry).otherProperties != null) {
            for (TMXProp prop : ((PrepareTMXEntry)entry).otherProperties) {
                buf.append(HttpCyclotisTMX.encodeArg("props." + prop.getType(), prop.getValue()));
            }
        }
        return buf.toString();
    }
}

