/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.silvestrislab.cyclotis.omegat.proj.ctx.DigestStringContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.EntryNumContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.FullStringContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.HashContextMode;

public abstract class ContextMode<T> {
    private Map<T, Integer> cache = new WeakHashMap<T, Integer>();

    public abstract T defaultValueForKey(SourceTextEntry var1);

    public abstract T nonDefaultValueForKey(SourceTextEntry var1);

    public abstract boolean isDefault(SourceTextEntry var1, T var2);

    public abstract boolean isCorrectKey(SourceTextEntry var1, T var2);

    public abstract void toDatabase(PreparedStatement var1, int var2, SourceTextEntry var3, boolean var4) throws SQLException;

    protected abstract void toDatabase(PreparedStatement var1, int var2, T var3) throws SQLException;

    public boolean isUnique() {
        return false;
    }

    public final T toDatabase(int entryNum, boolean isDefault) {
        SourceTextEntry key = (SourceTextEntry)Core.getProject().getAllEntries().get(entryNum - 1);
        if (isDefault) {
            return this.defaultValueForKey(key);
        }
        return this.nonDefaultValueForKey(key);
    }

    public final T toDatabase(SourceTextEntry key, boolean isDefault) {
        if (isDefault) {
            return this.defaultValueForKey(key);
        }
        return this.nonDefaultValueForKey(key);
    }

    public void fillEntry(ProjectMemory.ContextTMXEntry entry, ResultSet data) throws SQLException {
        this.fillEntry(entry, data.getObject("CONTEXT"));
    }

    public void fillEntry(ProjectMemory.ContextTMXEntry entry, T contextValue) {
        List entries = Core.getProject().getAllEntries();
        if (this.cache.get(contextValue) != null) {
            entry.entryNum = this.cache.get(contextValue);
        } else {
            try {
                entry.entryNum = Integer.parseInt(entry.getPropValue("entryNum"));
                SourceTextEntry ste = (SourceTextEntry)entries.get(entry.entryNum - 1);
                if (!this.isCorrectKey(ste, contextValue)) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                for (SourceTextEntry se : entries) {
                    if (this.isCorrectKey(se, contextValue)) {
                        entry.entryNum = se.entryNum();
                        break;
                    }
                    if (!this.isDefault(se, contextValue)) continue;
                    entry.entryNum = se.entryNum();
                }
            }
            this.cache.put(contextValue, entry.entryNum);
        }
        entry.isDefault = entry.entryNum == -1 || this.isDefault((SourceTextEntry)entries.get(entry.entryNum - 1), contextValue);
    }

    public static ContextMode<?> forProperties(Properties propList) throws Exception {
        String name = propList.getProperty("context.store").toUpperCase().replace(' ', '_');
        if (name.equals("ENTRY_NUM")) {
            return new EntryNumContextMode();
        }
        if (name.equals("HASH_CODE")) {
            return new HashContextMode();
        }
        if (name.equals("FULL_STRING")) {
            return new FullStringContextMode();
        }
        if (name.equals("DIGEST")) {
            String algo = propList.getProperty("context.store.algo").toUpperCase();
            if (algo == null) {
                algo = "MD5";
            }
            return new DigestStringContextMode(algo);
        }
        return null;
    }
}

