/*
 * Decompiled with CFR 0.152.
 */
package org.silvestrislab.cyclotis.omegat.proj.ctx;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.external.ProjectMemory;
import org.silvestrislab.cyclotis.omegat.proj.ctx.ContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.HashContextMode;
import org.silvestrislab.cyclotis.omegat.proj.ctx.StringContextMode;

public abstract class IntContextMode
extends ContextMode<Integer> {
    public static final IntContextMode DEFAULT = new HashContextMode();

    @Override
    public final void fillEntry(ProjectMemory.ContextTMXEntry entry, ResultSet data) throws SQLException {
        this.fillEntry(entry, data.getInt("CONTEXT"));
    }

    @Override
    protected final void toDatabase(PreparedStatement stmt, int pos, Integer contents) throws SQLException {
        stmt.setInt(pos, contents);
    }

    @Override
    public void toDatabase(PreparedStatement stmt, int pos, SourceTextEntry key, boolean isDefault) throws SQLException {
        stmt.setInt(pos, (Integer)this.toDatabase(key, isDefault));
    }

    public IntContextMode nullWrapper() {
        return new IntContextMode(){

            @Override
            public Integer defaultValueForKey(SourceTextEntry key) {
                return null;
            }

            @Override
            public Integer nonDefaultValueForKey(SourceTextEntry key) {
                return (Integer)IntContextMode.this.nonDefaultValueForKey(key);
            }

            @Override
            public boolean isDefault(SourceTextEntry key, Integer value) {
                return value == null;
            }

            @Override
            public boolean isCorrectKey(SourceTextEntry key, Integer value) {
                return IntContextMode.this.isCorrectKey(key, value);
            }

            @Override
            public void toDatabase(PreparedStatement stmt, int pos, SourceTextEntry key, boolean isDefault) throws SQLException {
                if (isDefault) {
                    stmt.setNull(pos, 4);
                } else {
                    super.toDatabase(stmt, pos, key, false);
                }
            }

            public String toString() {
                return "null or " + IntContextMode.this.toString();
            }
        };
    }

    public IntContextMode constWrapper(final int constVal) {
        return new IntContextMode(){

            @Override
            public Integer defaultValueForKey(SourceTextEntry key) {
                return constVal;
            }

            @Override
            public Integer nonDefaultValueForKey(SourceTextEntry key) {
                return (Integer)IntContextMode.this.nonDefaultValueForKey(key);
            }

            @Override
            public boolean isDefault(SourceTextEntry key, Integer value) {
                return value == null || value.equals(constVal);
            }

            @Override
            public boolean isCorrectKey(SourceTextEntry key, Integer value) {
                return IntContextMode.this.isCorrectKey(key, value);
            }

            @Override
            public void toDatabase(PreparedStatement stmt, int pos, SourceTextEntry key, boolean isDefault) throws SQLException {
                if (isDefault) {
                    IntContextMode.this.toDatabase(stmt, pos, this.defaultValueForKey(key));
                } else {
                    IntContextMode.this.toDatabase(stmt, pos, this.nonDefaultValueForKey(key));
                }
            }

            public String toString() {
                return "default(" + constVal + ") or " + IntContextMode.this.toString();
            }
        };
    }

    public static IntContextMode forProperties(Properties propList) {
        block11: {
            IntContextMode mode = null;
            try {
                mode = ContextMode.forProperties(propList);
            }
            catch (Exception e1) {
                mode = DEFAULT;
            }
            try {
                IntContextMode iMode = mode;
                String contextDefault = propList.getProperty("context.default");
                if (contextDefault != null) {
                    if (contextDefault.equalsIgnoreCase("setNull")) {
                        return iMode.nullWrapper();
                    }
                    if (contextDefault.toLowerCase().startsWith("const")) {
                        try {
                            int val = Integer.parseInt(contextDefault.substring(6));
                            return iMode.constWrapper(val);
                        }
                        catch (Exception valEx) {
                            return iMode.constWrapper(0);
                        }
                    }
                    break block11;
                }
                return iMode;
            }
            catch (Exception iNo) {
                try {
                    final StringContextMode sMode = (StringContextMode)((Object)mode);
                    return new IntContextMode(){

                        @Override
                        public Integer defaultValueForKey(SourceTextEntry key) {
                            return ((String)sMode.defaultValueForKey(key)).hashCode();
                        }

                        @Override
                        public Integer nonDefaultValueForKey(SourceTextEntry key) {
                            return ((String)sMode.nonDefaultValueForKey(key)).hashCode();
                        }

                        @Override
                        public boolean isDefault(SourceTextEntry key, Integer value) {
                            try {
                                return ((String)sMode.defaultValueForKey(key)).hashCode() == value.intValue();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }

                        @Override
                        public boolean isCorrectKey(SourceTextEntry key, Integer value) {
                            try {
                                return ((String)sMode.nonDefaultValueForKey(key)).hashCode() == value.intValue();
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }

                        public String toString() {
                            return "hashCode(" + sMode + ")";
                        }

                        @Override
                        public boolean isUnique() {
                            return sMode.isUnique();
                        }
                    };
                }
                catch (Exception iModeEx) {
                    return DEFAULT;
                }
            }
        }
        return DEFAULT;
    }
}

