/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class AbstractSpaceBeforeRule
extends Rule {
    protected abstract Pattern getConjunctions();

    public AbstractSpaceBeforeRule(ResourceBundle messages, Language language) {
        super.setCategory(Categories.MISC.getCategory(messages));
    }

    @Override
    public String getId() {
        return "SPACE_BEFORE_CONJUNCTION";
    }

    @Override
    public String getDescription() {
        return "Checks for missing space before some conjunctions";
    }

    protected String getShort() {
        return "Missing white space";
    }

    protected String getSuggestion() {
        return "Missing white space before conjunction";
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        for (int i = 1; i < tokens.length; ++i) {
            String previousToken;
            String token = tokens[i].getToken();
            Matcher matcher = this.getConjunctions().matcher(token);
            if (!matcher.matches() || (previousToken = tokens[i - 1].getToken()).equals(" ") || previousToken.equals("(")) continue;
            String replacement = " " + token;
            String msg = this.getSuggestion();
            int pos = tokens[i].getStartPos();
            RuleMatch potentialRuleMatch = new RuleMatch(this, pos, pos + token.length(), msg, this.getShort());
            potentialRuleMatch.setSuggestedReplacement(replacement);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

