/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.util.List;
import java.util.Map;
import org.omegat.core.machinetranslators.AbstractMyMemoryTranslate;
import org.omegat.util.Language;
import org.omegat.util.OStrings;

public final class MyMemoryMachineTranslate
extends AbstractMyMemoryTranslate {
    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_machine_translate";
    }

    @Override
    public String getName() {
        return OStrings.getString("MT_ENGINE_MYMEMORY_MACHINE");
    }

    @Override
    protected boolean includeMT() {
        return true;
    }

    @Override
    protected String translate(Language sLang, Language tLang, String text) throws Exception {
        Map<String, Object> jsonResponse;
        String prev = this.getFromCache(sLang, tLang, text);
        if (prev != null) {
            return prev;
        }
        try {
            jsonResponse = this.getMyMemoryResponse(sLang, tLang, text);
        }
        catch (Exception e) {
            return e.getLocalizedMessage();
        }
        double bestScore = 0.0;
        Map bestEntry = null;
        Map mtEntry = null;
        List matches = (List)jsonResponse.get("matches");
        for (Map entry : matches) {
            double score = ((Number)entry.get("match")).doubleValue();
            String createdBy = (String)entry.get("created-by");
            if ("MT!".equals(createdBy)) {
                mtEntry = entry;
                continue;
            }
            if (!(score > bestScore)) continue;
            bestEntry = entry;
            bestScore = score;
        }
        if (mtEntry != null) {
            bestEntry = mtEntry;
        }
        String translation = (String)bestEntry.get("translation");
        this.putToCache(sLang, tLang, text, translation);
        return translation;
    }
}

