/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.autocompleter;

import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.text.BadLocationException;
import org.omegat.core.Core;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.autocompleter.AutoCompleter;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;

public abstract class AbstractAutoCompleterView {
    private String name;
    protected AutoCompleter completer;

    public AbstractAutoCompleterView(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(AutoCompleter completer) {
        this.completer = completer;
    }

    public ITokenizer getTokenizer() {
        return Core.getProject().getTargetTokenizer();
    }

    public Language getTargetLanguage() {
        return Core.getProject().getProjectProperties().getTargetLanguage();
    }

    public abstract boolean processKeys(KeyEvent var1);

    public abstract int getRowCount();

    public abstract int getPreferredHeight();

    public abstract int getPreferredWidth();

    public abstract AutoCompleterItem getSelectedValue();

    public abstract void updateViewData();

    public abstract Component getViewContent();

    protected int getModifiedRowCount() {
        return Math.min(this.getRowCount() + 1, 10);
    }

    public abstract boolean shouldPopUp();

    public boolean shouldCloseOnSelection() {
        return true;
    }

    protected String getLeadingText() {
        try {
            EditorTextArea3 editor = this.completer.getEditor();
            int offset = editor.getCaretPosition();
            int translationStart = editor.getOmDocument().getTranslationStart();
            return editor.getDocument().getText(translationStart, offset - translationStart);
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    protected boolean isEnabled() {
        return true;
    }
}

