/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.filter.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;
import net.loomchild.maligna.filter.Filter;

public class FractionSelector
implements Filter {
    private float fraction;

    public FractionSelector(float fraction) {
        assert (fraction >= 0.0f && fraction <= 1.0f);
        this.fraction = fraction;
    }

    @Override
    public List<Alignment> apply(List<Alignment> alignmentList) {
        float threshold = this.calculateThreshold(alignmentList);
        ArrayList<Alignment> filteredAlignmentList = new ArrayList<Alignment>();
        for (Alignment alignment : alignmentList) {
            if (!(alignment.getScore() <= threshold)) continue;
            filteredAlignmentList.add(alignment);
        }
        return filteredAlignmentList;
    }

    private float calculateThreshold(List<Alignment> alignmentList) {
        float[] scoreArray = new float[alignmentList.size()];
        int index = 0;
        for (Alignment alignment : alignmentList) {
            scoreArray[index] = alignment.getScore();
            ++index;
        }
        Arrays.sort(scoreArray);
        float firstFiltered = this.fraction * (float)scoreArray.length - 0.5f;
        float threshold = firstFiltered < 0.0f ? Float.NEGATIVE_INFINITY : scoreArray[(int)firstFiltered];
        return threshold;
    }
}

