/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathFactory;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.matching.external.MenuMemory;
import org.omegat.util.CredentialsManager;
import org.omegat.util.JsonParser;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.WikiGet;

public class MyMemory
extends MenuMemory {
    private static final String MYMEMORY_API_EMAIL = "mymemory.api.email";
    protected static String GT_URL = "https://mymemory.translated.net/api/get?q=";
    protected static String GT_URL2 = "&langpair=#sourceLang#|#targetLang#&of=#format#";
    protected static String XPATH_QUERY_ALL_TU = "//tu";
    protected static String XPATH_QUERY_TUV = "child::tuv[starts-with(@lang, '#langCode#')]/seg/text()";
    protected static final DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
    protected static final XPathFactory xpathFactory = XPathFactory.newInstance();
    public static final SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyy-MM-dd  HH:mm:ss", Locale.ENGLISH);

    protected String mymemoryCode(Language language) {
        String lCode = language.getLocaleLCID();
        return lCode;
    }

    protected String buildMyMemoryUrl(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException {
        String sourceLang = this.mymemoryCode(sLang);
        String targetLang = this.mymemoryCode(tLang);
        String url2 = GT_URL2.replace("#sourceLang#", sourceLang).replace("#targetLang#", targetLang).replace("#format#", format);
        String url = GT_URL + URLEncoder.encode(text, "UTF-8") + url2;
        return url;
    }

    protected String getMyMemoryResponse(Language sLang, Language tLang, String text, String format) throws UnsupportedEncodingException, IOException {
        String url = this.buildMyMemoryUrl(sLang, tLang, text, format);
        String email = System.getProperty(MYMEMORY_API_EMAIL);
        if (email != null && "".equals(email)) {
            email = CredentialsManager.getInstance().retrieve(MYMEMORY_API_EMAIL).orElse("");
        }
        if (email != null && !"".equals(email)) {
            url = url + "&de=" + email;
        }
        String myMemoryResponse = "";
        myMemoryResponse = WikiGet.getURL(url);
        return myMemoryResponse;
    }

    @Override
    protected String getPreferenceName() {
        return "allow_mymemory_translation_memory";
    }

    @Override
    public String getMemoryName() {
        return OStrings.getString("XTM_ENGINE_MYMEMORY");
    }

    @Override
    public String getProviderName() {
        return OStrings.getString("XTM_ENGINE_MYMEMORY");
    }

    @Override
    public List<PrepareTMXEntry> retreiveMatchingTranslations(Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        try {
            String resText = this.getMyMemoryResponse(sLang, tLang, text, "json");
            Map response = (Map)JsonParser.parse(resText);
            List matches = (List)response.get("matches");
            ArrayList<PrepareTMXEntry> entries = new ArrayList<PrepareTMXEntry>(matches.size());
            for (Object obj : (List)response.get("matches")) {
                PrepareTMXEntry entry = new PrepareTMXEntry();
                response = (Map)obj;
                entry.source = response.get("segment").toString();
                entry.translation = response.get("translation").toString();
                System.out.println("****** " + entry.source + " >> " + entry.translation);
                try {
                    entry.creator = response.get("created-by").toString();
                    entry.changer = response.get("last-updated-by").toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                entries.add(entry);
            }
            return entries;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    protected String getXMLString(String str) {
        int XMLHeader = str.indexOf("<?xml");
        if (XMLHeader != -1) {
            str = str.substring(XMLHeader);
        }
        return str;
    }
}

