/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class PreferencesImpl
implements Preferences.IPreferences {
    private boolean m_changed;
    private final List<String> m_nameList;
    private final List<String> m_valList;
    private final Map<String, Integer> m_preferenceMap = new HashMap<String, Integer>(64);
    private final IPrefsPersistence m_backing;

    public PreferencesImpl(IPrefsPersistence backing) {
        this.m_nameList = new ArrayList<String>(32);
        this.m_valList = new ArrayList<String>(32);
        this.m_backing = backing;
        this.m_changed = false;
        this.m_backing.load(this.m_nameList, this.m_valList);
        for (int i = 0; i < this.m_nameList.size(); ++i) {
            this.m_preferenceMap.put(this.m_nameList.get(i), i);
        }
    }

    @Override
    public String getPreference(String key) {
        if (StringUtil.isEmpty(key)) {
            return "";
        }
        Integer i = this.m_preferenceMap.get(key);
        String v = "";
        if (i != null) {
            v = this.m_valList.get(i);
        }
        return v.toString();
    }

    @Override
    public boolean existsPreference(String key) {
        return this.m_preferenceMap.containsKey(key);
    }

    @Override
    public boolean isPreference(String key) {
        return "true".equals(this.getPreference(key));
    }

    @Override
    public boolean isPreferenceDefault(String key, boolean defaultValue) {
        String val = this.getPreference(key);
        if (StringUtil.isEmpty(val)) {
            this.setPreference(key, defaultValue);
            return defaultValue;
        }
        return "true".equals(val);
    }

    @Override
    public String getPreferenceDefault(String key, String defaultValue) {
        String val = this.getPreference(key);
        if (val.equals("")) {
            val = defaultValue;
            this.setPreference(key, defaultValue);
        }
        return val;
    }

    @Override
    public <T extends Enum<T>> T getPreferenceEnumDefault(String key, T defaultValue) {
        T r;
        String val = this.getPreference(key);
        try {
            r = Enum.valueOf(defaultValue.getDeclaringClass(), val);
        }
        catch (IllegalArgumentException ex) {
            r = defaultValue;
            this.setPreference(key, defaultValue);
        }
        return r;
    }

    @Override
    public int getPreferenceDefault(String key, int defaultValue) {
        String val = this.getPreferenceDefault(key, Integer.toString(defaultValue));
        int res = defaultValue;
        try {
            res = Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return res;
    }

    @Override
    public Object setPreference(String name, Object value) {
        if (StringUtil.isEmpty(name) || value == null) {
            return null;
        }
        if (value instanceof Enum && !value.toString().equals(((Enum)value).name())) {
            throw new IllegalArgumentException("Enum prefs must return the same thing from toString() and name()");
        }
        this.m_changed = true;
        String oldValue = null;
        Integer i = this.m_preferenceMap.get(name);
        if (i == null) {
            i = this.m_valList.size();
            this.m_preferenceMap.put(name, i);
            this.m_valList.add(value.toString());
            this.m_nameList.add(name);
        } else {
            oldValue = this.m_valList.set(i, value.toString());
        }
        return oldValue;
    }

    @Override
    public void save() {
        try {
            if (this.m_changed) {
                this.m_backing.save(this.m_nameList, this.m_valList);
                this.m_changed = false;
            }
        }
        catch (Exception e) {
            Log.logErrorRB("PM_ERROR_SAVE", new Object[0]);
            Log.log(e);
        }
    }

    static interface IPrefsPersistence {
        public void load(List<String> var1, List<String> var2);

        public void save(List<String> var1, List<String> var2) throws Exception;
    }
}

