/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen.tools;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import net.java.sen.util.CSVParser;
import net.java.sen.util.IOUtils;

public class CompoundWordTableCompiler {
    private static final String COMPOUND_CSV_FILENAME = "compound.csv";
    private static final String COMPOUND_TABLE_FILENAME = "compound.sen";
    private static final int PART_OF_SPEECH_START = 2;
    private static final int PART_OF_SPEECH_SIZE = 7;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildTable(BufferedReader reader, int partOfSpeechStart, int partOfSpeechSize, String tableFilename) throws IOException {
        String t;
        int line = 0;
        HashMap<String, String> compoundTable = new HashMap<String, String>();
        StringBuffer buffer = new StringBuffer();
        while ((t = reader.readLine()) != null) {
            CSVParser parser = null;
            try {
                int i;
                parser = new CSVParser(t);
                String[] csv = parser.nextTokens();
                if (csv.length < partOfSpeechSize + partOfSpeechStart) {
                    throw new RuntimeException("format error:" + line);
                }
                buffer.setLength(0);
                for (i = partOfSpeechStart; i < partOfSpeechStart + partOfSpeechSize - 1; ++i) {
                    buffer.append(csv[i]);
                    buffer.append(',');
                }
                buffer.append(csv[partOfSpeechStart + partOfSpeechSize - 1]);
                buffer.append(',');
                for (i = partOfSpeechStart + partOfSpeechSize; i < csv.length - 2; ++i) {
                    buffer.append(csv[i]);
                    buffer.append(',');
                }
                buffer.append(csv[csv.length - 2]);
                compoundTable.put(buffer.toString(), csv[csv.length - 1]);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(parser);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(parser);
        }
        FileOutputStream fos = null;
        ObjectOutputStream os = null;
        try {
            fos = new FileOutputStream(tableFilename);
            os = new ObjectOutputStream(fos);
            os.writeObject(compoundTable);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(os, fos);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(os, fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block10: {
            FileInputStream fileInputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader reader = null;
            fileInputStream = new FileInputStream(COMPOUND_CSV_FILENAME);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
            reader = new BufferedReader(inputStreamReader);
            CompoundWordTableCompiler.buildTable(reader, 2, 7, COMPOUND_TABLE_FILENAME);
            try {
                IOUtils.closeWhileHandlingException(reader, inputStreamReader, fileInputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            break block10;
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    try {
                        IOUtils.closeWhileHandlingException(reader, inputStreamReader, fileInputStream);
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                        System.exit(1);
                    }
                    throw throwable;
                }
                try {
                    IOUtils.closeWhileHandlingException(reader, inputStreamReader, fileInputStream);
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }
}

