The file template.html is written in html with some specific extensions.
Extensions will be interpreted by web-creator-html.pl; 
using attributes, most HTML editors may ignore them, meaning that you can use your favorite editor to create a better design.

The format is inspired by TAL language (https://docs.zope.org/zope2/zope2book/AppendixC.html) but no template engine is really used.
Here we will put all existing attributes, with meaning.

1. Local markups: replacement will occur exactly where the markup is
-----------------

tal:replace				
	Means that the containing markup will be replaced.
	For example <div tal:replace="message">...</div> will be replaced (from <div to </div>) by the contents of variable "message".
	Note that this variable is susceptible to contain html code as well.
tal:fill
	Means that the containing markup will be filled by the dynamic contents.
	For example if you have <div tal:fill="message">...</div> then only the contents (...) will be replaced by the message:
	</div>, <div> and all its attributes except tal: ones, will be kept as is.
	
2. Definition markups: 
----------------------
	
The markup and its contents is deleted, but then it is kept in memory and can be re-used one or more times, 
each time the Perl part makes reference to the id.
If the value contains other tal: instructions, they are kept in memory and will be re-evaluated for each occurence with the current environment.

tal:define-replace
	Defines id as the contents of markup, excluding markup itself
	For example <div tal:define-replace="message">...</div> sets "message" to "..."
tal:define-fill
	Defines id as the markup, including contents and all attributes except tal: ones.
	For example <div tal:define-replace="message" attr1=val1>...</div> sets "message" to "<div attr1=val1>...</div>"
tal:define-mark
	Defines id as the markup only, excluding contents. 
	Contents until the closing mark will be deleted from output. However if it contains other tal:defines, they will be in memory as well.
	For example <div tal:define-replace="message" attr1=val1><span tal:define-replace="test">1</span></div> 
		sets "test" to "1" and "message" to "<div attr1=val1>"	
tal:attr-XXX
	An attribute with name XXX will be generated (without tal:attr- before).
	
3. HTML constraints
-------------------

The code must contain a <main> markup to make the distinction between what is common to all pages and specific to the forms/list page.
Attribute tal:use, mandatory, says whenever the <main> markup must appear in the result (use=true or use=fill) or not (use=replace, use=false).
All what is outside the main is considered as common template, also usable for information pages.
