=head1 Format 'yaml'

Returns a YAML array, with each line containing a hash of key/value pairs, corresponding to the table schema.

=cut
package Silvestris::Cyclotis::Format::cpan::yaml;
use parent Silvestris::Cyclotis::Format::cpan;

use YAML;

sub new {
    my ($class, %params) = @_; 
    bless \%params, 'Silvestris::Cyclotis::Format::cpan::yaml'; 
}


sub MIME { 'application/x-yaml' }

sub dump {
    my ($self, $ref) = @_;
	local $YAML::Indent; $YAML::Indent = $self->{indent} if $self->{indent};
	return YAML::Dump($ref);
}

sub read_line {
    shift; my $FH = shift; my $decode = YAML::Load($FH);
	if (ref($decode) =~ /ARRAY/) {
		my $item = shift @$decode; $$FH = YAML::Dump($decode); return $item;
	} elsif (ref($decode) =~ /HASH/) {
		if ($decode->{result}) {	# envelope, contents is in 'result' field
			my $item = shift @{$decode->{result}}; $$FH = YAML::Dump($decode); return $item;
		}
		elsif ($decode->{contents}) {	# envelope, contents is in 'contents' field
			my $item = shift @{$decode->{contents}}; $$FH = YAML::Dump($decode); return $item;
		}
		elsif ($decode->{src}) {	# no envelope
			$$FH = ''; return $decode;
		}
	}
}

sub needs_field { 
	if (defined $_[0]->{fields}) { 
		if (ref ($_[0]->{fields})) { return grep { /$_[1]/ } @{$_[0]->{fields}}; } # as an array
		else { return ($_[0]->{fields} =~ /$_[1]/); }	# comma-separated string
	}
	if (defined $_[0]->{meta}) {  
		if (ref ($_[0]->{meta})) { return grep { /$_[1]/ } @{$_[0]->{meta}}; } # as an array
		else { return ($_[0]->{meta} =~ /$_[1]|all/); }	# comma-separated string
	}
	return $_[0]->SUPER::needs_field($_[1]);
}


sub openapi {
  my ($self, $indent, $config) = @_;
  require Silvestris::Dancer::MyRoutes unless Silvestris::Dancer::MyRoutes->can('openapi');
  my %struct = Silvestris::Dancer::MyRoutes->openapi;
  return $self->dump(\%struct);
}

1;

=head1 LICENSE

Copyright 2014-2017 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
