#! /usr/bin/env plackup

=head1 DESCRIPTION

This file adds a hook to an existing Dancer application.
It produces one entry per HTTP request

=cut

use Dancer;
unless (config->{debug}{time}) { # else, this is already done by cyclotis-rest-api.pl
	use Time::HiRes; hook before => sub { var 'start_time' => Time::HiRes::time(); };
}

my $usageLog = config->{'usage-log'};

if (my $db = $usageLog->{db}) {
	my $dbh;
	if ($db->{url}) { use DBI; $dbh = DBI->connect(@{$db}{'url','user','password'}); } else { use Dancer::Plugin::Database; $dbh = database; }
	foreach my $col ('date', 'duration', 'method', 'table', 'user') { $db->{col}{$col} ||= $col; }
	my %cols = ( 
		$db->{col}{method} => sub { var('command') || request->method() },
		$db->{col}{duration} => sub { Time::HiRes::time() - var 'start_time' },
		$db->{col}{user} => sub { var('auth_user') },		
	);
	# Optional columns
	$cols{$db->{col}{query}} = sub { param('query') } if $db->{col}{query};
	 if ($db->{col}{results_count}) { 
		$cols{$db->{col}{results_count}} = sub { var 'results_count' };
		hook before => sub { var 'results_count' => 0; };
	}
	
	if ($db->{col}{mem_id}) {
		push(@main::INC, '..') unless grep { $_ eq '..' } @main::INC; require Silvestris::Cyclotis::Database::Table;
		$cols{$db->{col}{mem_id}} = sub {
			my $table = find Silvestris::Cyclotis::Database::Table(param('db'), param('table'), param('schema')) or return undef;
			return $table->{mem_id};
		};
	}
	elsif ($db->{col}{mem_code}) {
		push(@main::INC, '..') unless grep { $_ eq '..' } @main::INC; require Silvestris::Cyclotis::Database::Table;
		$cols{$db->{col}{mem_code}} = sub {
			my $table = find Silvestris::Cyclotis::Database::Table(param('db'), param('table'), param('schema')) or return undef;
			return $table->{mem_code};
		};
	}
	if ($db->{col}{schema}) {
		$cols{$db->{col}{schema}} = sub {
			my ($schema) = param ('schema'); my $table = param('table');
			if ($schema) { return $schema; } else {
				if ($table =~ /^(\w+)\.(\w+)$/) { return $1; } else { return 'public'; }
			}
		};
		$cols{$db->{col}{table}} = sub {
			my $table = param('table');
			if ($table =~ /^(\w+)\.(\w+)$/) { return $2; } else { return $table; }
		};
	} else {
		$cols{$db->{col}{table}} = sub {
			my ($schema) = param ('schema'); my $table = param('table');
			if ($schema) { return "$schema.$table"; } elsif ($table =~ /\./) { return $table; } else { return "public.$table"; }
		};
	}
	
	my @keys = keys(%cols);
	my $statement = $dbh->prepare(
			sprintf("insert into $db->{table} ($db->{col}{date},%s)",  join(',',@keys))
				. sprintf(" values (NOW(), %s)", join(',', map {'?'} @keys))
	);
	$Silvestris::Logger::loggerFunc = sub {
		$statement->execute (map { &{$cols{$_}}() } @keys);
	};
} elsif (my $file = $usageLog->{file}) {	
	local *LOG; my $dest = *LOG;
	$file = $file->{location} if ref($file); open(LOG, ">> $file") or die "$! $file"; LOG->autoflush(1); 
	require POSIX; my $format = $usageLog->{format} || '%m-%d %H:%M:%S	$TIME	$COMMAND	$SCHEMA.$TABLE	$USER	$COUNT';
	$Silvestris::Logger::loggerFunc = sub {	
		my $res = POSIX::strftime ($format, localtime());
		$res =~ s!\$TIME!sprintf('%.4f', Time::HiRes::time() - var 'start_time')!e;
		$res =~ s!\$COMMAND!var('command') || request->method()!e;
		$res =~ s!\$COUNT!defined (var('results_count')) ? var('results_count') : '-'!e;
		my ($schema, $table) = (param('schema'), param('table')  || '-');
		if ($table =~ s/^(\w+)\.//) { $schema = $1; } else { $schema ||= 'public'; }
		$res =~ s!\$TABLE!"$table"!e; $res =~ s!\$SCHEMA!"$schema"!e; $res =~ s!\$DB!param('db') || 'default'!e; 
		$res =~ s!\$USER!var ('auth_user') || '-'!e;
		print $dest $res, "\n";
	};
}

hook before => sub { var 'streaming' => 0; };

hook after => sub { &$Silvestris::Logger::loggerFunc() unless var 'streaming'; } if $Silvestris::Logger::loggerFunc;

dance();

=head1 LICENSE

Copyright 2015 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
