﻿=head1 DESCRIPTION

These are the routes to access meta-information, i.e. info about the tables rather than contents.

=cut

use Dancer; 

use Silvestris::Cyclotis::Format;
use Silvestris::Dancer::MyRoutes;

sv_route 'admin.status' => get => '/status(/:types)?(/:level)?(.:fmt)?' => sub {
	my $fmt = Silvestris::Cyclotis::Format->for_dancer_params(); content_type $fmt->MIME() . "; charset=utf-8"; 
	
	my @QUERIES = map {
		 my $res = ''; my $copy = $_;
		 $res .= 'insert' if $copy =~ /insert/i; $res .= 'select' if $copy =~ /select/;
		 $res .= ' ' . $2 if /(into|from)\s+([\w\.]+)/;
		 $res
	} keys %{database->{CachedKids}};

	my %LIB; my @DATE; if (param('level') > 1) { %LIB = %main::INC; } else { %LIB = map { $_ => $main::INC{$_} } grep { m!^Silvestris/! } keys %main::INC; }
	%LIB = map {
		@DATE = stat($main::INC{$_}); @DATE = localtime($DATE[9]); $DATE[4]++; $DATE[5] += 1900;
		my $name = $_; my $perl = $_; $name =~ s!/!::!g; $name =~ s/\.pm$//;
		{$name => { location => $main::INC{$perl}, date => "$DATE[5]-$DATE[4]-$DATE[3] $DATE[2]:$DATE[1]:$DATE[0]", version => eval sprintf('$%s::VERSION',$name) }}
	} keys %LIB;
	@DATE = stat('cyclotis-rest-api.pl'); @DATE = localtime($DATE[9]); $DATE[4]++; $DATE[5] += 1900;
	$LIB{'cyclotis-rest-api.pl'} = { location => $0, date => "$DATE[5]-$DATE[4]-$DATE[3] $DATE[2]:$DATE[1]:$DATE[0]" };
	
	return $fmt->show_status (param('level') || 1, param('types') || 'cache,libs', \@QUERIES, \%LIB);
};

sv_route 'admin.view_log' => get => '/log(.:fmt)?' => sub {
	my $fmt = Silvestris::Cyclotis::Format->for_dancer_params(); content_type $fmt->MIME() . "; charset=utf-8"; 
	
	my $log = {};
	if (my $file = config->{'usage-log'}{file}) {
		my ($groupVar, $groupExpr, $groupRes) = split(/:/, $file->{view}{group});
		$groupVar =~ s/\#(\d+)/\$cols\[$1 \- 1\]/g; 
		my $groupFun = sub { my @cols = @_; return eval $groupRes if eval ($groupVar) =~ $groupExpr; };
		# Accumulation of values
		local *F; open(F, $file->{location});
		while (my $line = <F>) {
			my @cols = split($file->{view}{split} || "\t", $line); my $lineGroup = &$groupFun(@cols);
			unless ($log->{$lineGroup}) {
				$log->{$lineGroup} = { map { $_ => eval {
						my $expr = $file->{view}{columns}{$_};
						$expr =~ s!\$group!"$lineGroup"!e;
						$expr = 1 if $expr eq 'count(*)';
						if ($expr =~ /^(count|avg)\(\#(\d+)\)$/) {
							$expr = [ $cols[$2 - 1] ];
						}
						$expr
					}				
				} @{$file->{view}{'columns-order'}} };
			} else {
				for (my $i = 0; $i < @{$file->{view}{'columns-order'}}; $i++) {
					my $colName = $file->{view}{'columns-order'}[$i]; my $expr = $file->{view}{columns}{$colName};
					$log->{$lineGroup}{$colName}++ if $expr eq 'count(*)';
					if ($expr =~ /^(count|avg)\(\#(\d+)\)$/) {
						push (@{$log->{$lineGroup}{$colName}}, $cols[$2 - 1]);
					}
				}
			}
		}
		close(F); $log->{__ORDER__} = $file->{view}{'columns-order'};
		# Simplification
		foreach my $line (values %$log) {
			next unless ref ($line) =~  /HASH/; # all but order
			while (my ($k, $v) = each (%$line)) {
				my $expr = $file->{view}{columns}{$k};
				next if $expr eq 'count(*)';
				if ($expr =~ /^count/) {
					my %toHash = (); $toHash{$_}++ foreach @$v;
					$line->{$k} = scalar keys %toHash;
				}
				if ($expr =~ /^avg/) {
					my $sum = 0.0; $sum+=$_ foreach @$v; $line->{$k} = $sum / scalar(@$v);
				}
			}
		}
	}
	
	return $fmt->show_log ($log);
};


dance();


=head1 LICENSE

Copyright 2014-2015 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
