=head1 DESCRIPTION

Base class for formats implemented without any CPAN dependency

=cut
package Silvestris::Cyclotis::Format::nodep;
use parent Silvestris::Cyclotis::Format;

use Dancer qw(var);

# Method which should be correct for most formats
sub produce {
    my ($self, $st, $query, $tableRef, $view, $filter) = @_;
    my $txt = $self->header(query => $query);
	return $txt . $self->footer() if $view =~ /check/; 
	my $count = 0;
LINE:
    while (my $line = $st->fetchrow_hashref) {
		$count++; next if $view =~ /count/;
		$tableRef->expand($line) if $tableRef->has_structured_content(); $self->reformat_dates ($line);
		if ($filter) { $line->{$_} = &$filter($line->{$_}, $query, $line) foreach ('src','tra'); }
		$txt .= $self->produce_line($line);
    }
    $txt .= $self->footer($count); var 'results_count' => $count;
    return $txt;
}

sub produce_as_stream {
    my ($self, $st, $writer, $query, $tableRef, $view, $filter) = @_;
    $writer->write ($self->reencode("utf", $self->header(query => $query)));
    $writer->write ($self->reencode(undef, $self->footer())) and return() if $view =~ /check/; 
    my $count = 0;
LINE:
    while (my $line = $st->fetchrow_hashref) {
   		$count++; next if $view =~ /count/;
		  $tableRef->expand($line) if $tableRef->has_structured_content(); $self->reformat_dates ($line);
		  if ($filter) { $line->{$_} = &$filter($line->{$_}, $query, $line) foreach ('src','tra'); }
		  $writer->write ($self->reencode(undef, $self->produce_line($line)));
    }
	var 'results_count' => $count;
    $writer->write ($self->reencode(undef, $self->footer($count)));
}

sub produce_write_response {
	my ($self, $lines) = @_;
	return $self->header() . join('',map { $self->status_line($_) } @$lines) . $self->footer(scalar(@$lines)); 
}

1;

=head1 LICENSE

Copyright 2014-2015 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
