=head2 Format 'perl'

Returns a Perl array, with each line containing a hash of key/value pairs, corresponding to the table schema.

=cut
package Silvestris::Cyclotis::Format::nodep::perl;
use parent 'Silvestris::Cyclotis::Format::nodep::serial';

sub MIME { 'application/x-perl' }

sub dump_key_val {
	my ($self, $key, $val) = @_;
	$key = qq("$key") if $key =~ /\s/;
	return "$key => " . $self->dump_struct($val);
}

sub read_line {
    shift; my $FH = shift; my $txt; ($txt, $$FH) = ($$FH =~ m!^.*?(\{.+?\})(.*)!s);
	until (scalar($txt =~ /\{/g) == scalar($txt =~ /\}/g)) {
		my $txt1; ($txt1, $$FH) = ($$FH =~ m!^.*?(\{.+?\})(.*)!s); $txt .= $txt1;
	}
    my $hash; if (eval "\$hash = $txt;") { return %$hash if $hash->{src}; }  return();	
}

1;

=head1 LICENSE

Copyright 2013-2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
