#! perl

# --------- This file is used to configure Silvestris::Cyclotis::SoapServer. Modify it to set the parameters for your server

# --- add here the libraries, if not in the Apache config file
BEGIN {
	foreach my $lib ('list','of','library','pathes') {
		push(@INC, $lib) unless grep { $_ eq $lib } @INC;	# cannot 'use lib' because even lib.pm may be impossible to find
	}
}

# --------- This is the configuration of Cyclotis soap server
%Silvestris::Cyclotis::SoapServer::CONFIG = (
	# Put here the DBI parameters for the databases you want to give access to
	databases => {
		sample-db => [ 'dbi:Pg:Test', 'me', 'password' ]
	},
	# Can send debug anywhere
	debug => {
		sql => sub { print STDERR shift; },
		time => sub { print STDERR "Query time: ", shift, "\n"; },
	},
);