#! /usr/bin/env perl

=head1 test-queries.pl

Test search query builder

=cut

use lib '../rest';
use Silvestris::Cyclotis::Database::Query::Search;

my $query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'fuzzy', tableName => 'test');
my $sql = $query->toSQL; print "First query: $sql\n";

$query = $query->addParam_version ('2014-01-01');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_version"; }
$sql = $query->toSQL; print "\tWith version: $sql\n";

$query = $query->addParam_lang ('fr');
if ($query->toSQL ne $sql) { die "Parameter lang should not have effect here\n"; }
else { print "\taddLang has no effect here, it is normal.\n"; }

$query = $query->addParam_sort ('+SRC,-TRA');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_version"; }
$sql1 = $sql = $query->toSQL; print "\tWith order: $sql\n";

$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'fuzzy', tableName => 'test');
$query = $query->addParam_sort ('+SRC,-TRA');
$query = $query->addParam_version ('2014-01-01');
if ($sql1 eq $query->toSQL) { print "\tChange between addParam_sort and addParam_version OK"; }
else { die "\tChange between addParam_sort and addParam_version Failed"; }

$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concSrc', tableName => 'test');
$sql = $query->toSQL; print "Second query: $sql\n";

$query = $query->addParam_version ('2014-01-01');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_version"; }
$sql = $query->toSQL; print "\tWith version: $sql\n";

$query = $query->addParam_lang ('fr');
if ($query->toSQL ne $sql) { die "Parameter lang should not have effect here\n"; }
else { print "\taddLang after version has no effect here, it is normal.\n"; $sql1 = $sql; }

$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concSrc', tableName => 'test');
$sql = $query->toSQL;
$query = $query->addParam_lang ('fr');
if ($query->toSQL ne $sql) { die "Parameter lang should not have effect here\n"; }
else { print "\taddLang before version has no effect here, it is normal.\n"; }
$query = $query->addParam_version ('2014-01-01');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_version"; }
$sql = $query->toSQL; print "\tWith lang+version: $sql\n";
if ($sql eq $sql1) { print "Parameters version and lang can be interchanged\n\n"; }
else { die "Parameters version and lang cannot be interchanged";}


print "\nTest explicit date format\n";
{ package Simulate::Database::Table; sub fieldList { keys(%{$_[0]->{fields}}) } } # avoid loading Dancer
my $tableRef = bless { fields => { 'src' => 1, 'tra' => 1 } }, Simulate::Database::Table;
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'all', tableName => 'test', tableRef => $tableRef);
$sql = $query->toSQL; print "\tNo explicit: $sql\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'all', tableName => 'test', tableRef => $tableRef, sqlConfig => { explicit => [ 'date' ] });
print "\tWith explicit: ", $query->toSQL, "\n";
if ($sql eq $query->toSQL) { die "Explicit not working."; }
elsif ($query->toSQL =~ /(date)\s*([<>=]+)\s*(:\w+)/) { die "Some dates have not been expanded"; }
else { print "Seems OK.\n\n"; }

print "Test explicit vector format\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concTra', tableName => 'test');
$sql = $query->toSQL; print "\tNo explicit: $sql\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concTra', tableName => 'test', sqlConfig => { explicit => [ 'date' ] });
print "\tWith explicit date: ", $query->toSQL, "\n";
if ($sql eq $query->toSQL) { print "OK, explicit date has no effect\n"; }
else { die "Explicit date has effect.Humm....\n"; }
$query->{sqlConfig}{explicit} = [ 'ts_vector' ];
print "\tWith explicit vector: ", $query->toSQL, "\n";
if ($sql eq $query->toSQL) { die "Explicit not working."; }
elsif ($query->toSQL =~ /\w+\s*\@\@/) { die "Some dates have not been expanded"; }
else { print "Seems OK.\n\n"; }
if ($query->toSQL =~ /\@\@\s*plainto_tsquery\(:\w+/) { print "\tQuery expanded to ensure same lexer\n"; }
else { die "Query has not been expanded, it should to ensure same lexer"; }
$sql= $query->toSQL;
@{$query->{sqlConfig}{explicit}} = ('ts_query');
print "\tWith explicit query: ", $query->toSQL, "\n";
if ($sql eq $query->toSQL) { die "Explicit query not working."; }
elsif ($query->toSQL =~ /\@\@\s*:\w+/) { die "Some dates have not been expanded"; }
else { print "Seems OK.\n\n"; }

print "\nTest scores\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'exact', tableName => 'test');
$sql = $query->toSQL; print "Test query: $sql\n";
$query = $query->addParam_displayScore('score');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_displayScore"; }
$sql1 = $sql = $query->toSQL; print "\tWith score: $sql\n";
$query = $query->addParam_displayScore('score(tokenize)');
if ($query->toSQL eq $sql || $query->toSQL eq $sql1) { die "Failed to apply  addParam_displayScore"; }
$sql = $query->toSQL; print "\tWith score(tokenize): $sql\n";
$query = $query->addParam_displayScore('score(tokenize(untag))');
if ($query->toSQL eq $sql || $query->toSQL eq $sql1) { die "Failed to apply  addParam_displayScore"; }
$sql = $query->toSQL; print "\tWith score(tokenize(untag)): $sql\n";
$query = $query->addParam_filterContents('untag');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_filterContents"; }
$sql = $query->toSQL; print "\tWith untag(contents): $sql\n";
$query = $query->addParam_filterInput('tokenize(untag)');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_filterContents"; }
$sql = $query->toSQL; print "\tWith tokenize(untag(contents)): $sql\n";

print "\nTest mem_id\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concSrc', tableName => 'test01memid');
$sql = $query->toSQL; print "Initial query: $sql\n";
$tableRef->{mem_id} = 5; $tableRef->{std_parent} = 'memx'; 
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concSrc', tableName => 'test01memid', tableRef => $tableRef);
if ($sql eq $query->toSQL) { die "mem_id is not working : same result."; }
elsif ($query->toSQL =~ /\btest01memid\b/) { die "mem_id does not prevent from using initial table\n"; }
elsif ($query->toSQL !~ /:mem/) { die "mem_id does not generate :variable"; }
else { print "\tWith mem_id: ", $query->toSQL, "\n"; }
$query = $query->addParam_version ('2014-01-01');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_version"; }
elsif ($query->toSQL =~ /\btest01memid\b/) { die "mem_id does not prevent from using initial table\n"; }
elsif ($query->toSQL !~ /:mem/) { die "mem_id does not generate :variable"; }
$sql = $query->toSQL; print "\tWith version: $sql\n";
$query->addParam_filterContents('untag');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_filterContents"; }
elsif ($query->toSQL =~ /\btest01memid\b/) { die "mem_id does not prevent from using initial table\n"; }
elsif ($query->toSQL !~ /:mem/) { die "mem_id does not generate :variable"; }
$sql = $query->toSQL; print "\tWith untag(contents): $sql\n";


print "\nTest uniq\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concSrc', tableName => 'test', tableRef => $tableRef);
$sql = $query->toSQL; print "Second query: $sql\n";
{ package Simulate::Database::Table; sub null_or_default { "coalesce($_[1],'')" } } # avoid loading Dancer
$query = $query->addParam_uniq('src');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_uniq"; }
$sql = $query->toSQL; print "\tNo date: With uniq(src):\n\t\t$sql\n";
$tableRef->{fields}{date} = 'date';
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'concSrc', tableName => 'test', tableRef => $tableRef);
$query = $query->addParam_uniq('src');
if ($query->toSQL eq $sql) { die "Failed to apply  addParam_uniq"; }
$sql = $query->toSQL; print "\tWith date: With uniq(src):\n\t\t$sql\n";

print "\nTest sort and page parameters\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'fuzzy', tableName => 'test');
$query = $query->addParam_sort ('+SRC', '-TRA');
$query = $query->addParam_page (5);
$sql1 = $query->toSQL; print "\t$sql1\n";
$query = new Silvestris::Cyclotis::Database::Query::Search(cmd => 'fuzzy', tableName => 'test');
$query = $query->addParam_page (5);
$query = $query->addParam_sort ('+SRC', '-TRA');
if ($query->toSQL eq $sql1) { print "Parameters page and sort can be interchanged\n"; }  else { die "Parameters page and sort cannot be interchanged : \n\t$sql1\n\t" . $query->toSQL . "\n"; }
$query = $query->addParam_page (5, 3);
$sql1 = $query->toSQL; print "\t$sql1\n";
if ($query->toSQL eq $sql1) { print "Can re-apply addParam_page\n"; }  else { die "Failed to re-apply addParam_page\n"; }


print "\nTest partial search modes\n";
print "\tiregexSrc works : OK\n" if Silvestris::Cyclotis::Database::Query::Search->sqlExpressionForCommand('iregexSrc') eq 'Src ~* :txt';
print "\tiregexField forbidden: OK\n" unless Silvestris::Cyclotis::Database::Query::Search->sqlExpressionForCommand('iregexField');
print "\tcontainsAny, table contains no note\n";
$query = Silvestris::Cyclotis::Database::Query::Search->sqlExpressionForCommand('containsAny', $tableRef);
if ($query !~ /position/) { print "\t\tcontainsAny: not a contains query ($query)\n"; }
elsif ($query !~ /src/) { print "\t\tcontainsAny: should contain 'src' ($query)\n";  }
elsif ($query !~ /tra/) { print "\t\tcontainsAny: should contain 'tra' ($query)\n";  }
elsif ($query =~ /note/) { print "\t\tcontainsAny: should NOT contain 'note' ($query)\n";  }
elsif ($query =~ / and / or $query !~ / or /) { print "\t\tcontainsAny: should be an 'OR' query ($query)\n";  }
else { print "\t\tcontainsAny: seems OK ($query)\n";  }
$tableRef->{fields}{note} = 1;
print "\tcontainsAll, table has a note\n";
$query = Silvestris::Cyclotis::Database::Query::Search->sqlExpressionForCommand('containsAll', $tableRef);
if ($query !~ /position/) { print "\t\tcontainsAll: not a contains query ($query)\n"; }
elsif ($query !~ /src/) { print "\t\tcontainsAll: should contain 'src' ($query)\n";  }
elsif ($query !~ /tra/) { print "\t\tcontainsAll: should contain 'tra' ($query)\n";  }
elsif ($query !~ /note/) { print "\t\tcontainsAll: should contain 'note' ($query)\n";  }
elsif ($query !~ / and / or $query =~ / or /) { print "\t\tcontainsAll: should be an 'AND' query ($query)\n";  }
else { print "\t\tcontainsAll: seems OK ($query)\n";  }
print "\tcontainsSegAll, table has a note\n";
$query = Silvestris::Cyclotis::Database::Query::Search->sqlExpressionForCommand('containsSegAll', $tableRef);
if ($query !~ /position/) { print "\t\tcontainsSegAll: not a contains query ($query)\n"; }
elsif ($query !~ /src/) { print "\t\tcontainsSegAll: should contain 'src' ($query)\n";  }
elsif ($query !~ /tra/) { print "\t\tcontainsSegAll: should contain 'tra' ($query)\n";  }
elsif ($query =~ /note/) { print "\t\tcontainsSegAll: should NOT contain 'note' ($query)\n";  }
elsif ($query !~ / and / or $query =~ / or /) { print "\t\tcontainsSegAll: should be an 'AND' query ($query)\n";  }
else { print "\t\tcontainsSegAll: seems OK ($query)\n";  }
