=head2 Format 'html'

This format only supports info query and error messages.
It should only be used when a tester tries to access the application using a browser.

=cut
package Silvestris::Cyclotis::Format::nodep::html;
use parent Silvestris::Cyclotis::Format::nodep;

use Dancer ':syntax';

sub new {
    my (undef, %params) = @_;
    return bless \%params;
}

sub MIME { 'text/html' }


sub produce_error {  
	my $err = $_[1]; 
	$err = sprintf('<h2>Error %s</h2><br/> %s', $err->code, $err->message) if ref($err) and $err->isa('Dancer::Error');

	return << "EOF";
<html>
  <head>
     <title>Silvestris Cyclotis REST server: ERROR</title>
  </head>
  <body>
      $err
  </body>
</html>
EOF
}


sub envelope {
	return << "EOF";
<html>
  <head>
     <title>Silvestris Cyclotis REST server: OK</title>
  </head>
  <body>
       This is Cyclotis REST server. <br/>
       This server should answer in plain text, TMX, JSON or YAML. 
       You are receiving this response in HTML because we detected that you make use of a browser.
       This is only allowed for test queries, which do not call the database. <br/> <br/> <br/>
       
      $_[1]       
  </body>
</html>
EOF

}

sub produce_info { 
	my ($self, $formats, $url, $allow, $timestamp, $tables) = @_;

	my $FMT = ''; my $uri = request->request_uri; if ($uri =~ /\?/) { $uri .= '&'; } else { $uri .= '?'; }
	foreach my $f ('line', 'json', 'yaml', 'xml') {
		$FMT .= "<a href='${uri}fmt=$f'>$f</a> &nbsp;&nbsp;&nbsp;";
	}

	return $self->envelope(<< "EOF");
       Have a look at same response in other formats : $FMT <br/><br/>
       Supported URL:
       <table border=1>
       <tr><td>Table structure:</td><td>$url->{struct}</td></tr>
       <tr><td>Find contents:</td><td>$url->{contents}{find}</td></tr>
       <tr><td>Save contents:</td><td>$url->{contents}{save}</td></tr>
       </table>
EOF
}


sub show_status {
	my ($self, $level, $types, $Queries, $Lib) = @_; my $res = "";
	unless ($types !~ /cache/) {
		if ($level <= 1) { $res .= "" . scalar (keys (%Silvestris::Cyclotis::Database::Table::CACHE)) . " tables "; }
		else {
			$res .= "\tTables (" . scalar (keys (%Silvestris::Cyclotis::Database::Table::CACHE)) . "): ";
			$res .= "$_," foreach keys (%Silvestris::Cyclotis::Database::Table::CACHE);
		}
		$res .= "<br/>";$res .= "<br/>";
		
		if ($level <= 1) { $res .= "" . scalar(@$Queries) . " queries."; } else {
			$res .= "Queries (" . scalar(@$Queries) . "): ";
			foreach (@$Queries) {
				if (/^(insert|update|select|delete)\s+([\w\.]+)/) {
					$res .= "$1 $2, <br/>";
				} else {
					$res .= "$_\n";
				}
			}
		}
	}
	$res .= "<br/>";$res .= "<br/>";
	unless ($types !~ /libs/) {
		$res .= "Libraries: <br/><dl>\n";
		while (my ($lib, $hash) = each (%$Lib)) {
			$res .= "<dt>$lib</dt><dd> Location: $hash->{location} <br/> version=: $hash->{version} <br/> date: $hash->{date}";
		}
		$res .= "\t</dl>\n";
	}

  return $self->envelope ($res);
}


1;

=head1 LICENSE

Copyright 2016 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
