=head2 Format 'json'

Returns a JSON array, with each line containing a hash of key/value pairs, corresponding to the table schema.

=cut
package Silvestris::Cyclotis::Format::nodep::json;
use parent 'Silvestris::Cyclotis::Format::nodep::serial';

sub MIME { 'application/json' }

sub dump_key_val {
	my ($self, $key, $val, $i) = @_;
	return qq("$key": ) . $self->dump_struct($val, $i);
}

sub dump_struct {	# if struct is a string, encode characters which are forbidden in a JSON string
	my ($self, $struct, $indent, $fields) = @_;
	return $self->SUPER::dump_struct($struct, $indent, $fields) if ref $struct;
	$struct = $self->SUPER::dump_struct($struct, $indent, $fields);
	$struct =~ s/\t/\\t/gs; $struct =~ s/\x08/\\b/gs; $struct =~ s/\f/\\f/gs; $struct =~ s/\n/\\n/g; $struct =~ s/\r/\\r/g;
	return $struct;
}

sub read_line {
    shift; my $FH = shift; my $txt; ($txt, $$FH) = ($$FH =~ m!^.*?(\{.+?\})(.*)!s);
	$txt =~ s/(['"])(.+?)\1\s*:\s*([\'["])?(.+?)\3/'$2' => '$4'/gs;    # JSON to Perl
	until (scalar($txt =~ /\{/g) == scalar($txt =~ /\}/g)) {
		my $txt1; ($txt1, $$FH) = ($$FH =~ m!^.*?(\{.+?\})(.*)!s); $txt .= $txt1;
	}
    my $hash; if (eval "\$hash = $txt;") { return %$hash if $hash->{src}; } return ();
}

1;

=head1 LICENSE

Copyright 2013-2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or  as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
