#! /usr/bin/env plackup

=encoding utf-8
=head1 DESCRIPTION

This is a REST service to access Cyclotis database. Runnable via any PSGI server.

=head1 USAGE

    plackup cyclotis-rest-api.pl
	
or configure a PSGI environment via your favorite server.

=head1 Authentication

By default there is no authentication at application level, i.e. it can be done by the web server before.

With config parameter auth_db you can decide to do authentication here. See config.yml sample and hooks/auth.pl for details.

=cut

use Dancer;

# ---- Initial hooks ----
load 'hooks/cleaner.pl' if config->{'cleaner'};	# clean before all, to be sure to reload old data
load 'hooks/auth.pl' if config->{'auth-db'};

=head1 HTTP routes

Here we display the default URL patterns. Exact format of the url is modifiable in the config file (see example in config.yml)

=cut

load "routes/contents.pl";
load "routes/meta.pl";
load "routes/admin.pl";
load "routes/doc.pl" if -e "routes/doc.pl";
 
# ---- Final hooks ----
load "hooks/errors.pl";
load 'hooks/logger.pl' if config->{'usage-log'};

dance();

=head1 LICENSE

Copyright 2013-2015 Silvestris Project (L<http://www.silvestris-lab.org/>)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
