=head1 DESCRIPTION

These are hooks to manage error messages. This is not a full application.

=cut

use Dancer;
use Silvestris::Cyclotis::Format;

if (config->{debug}{time}) {
	require Time::HiRes;
	
	hook before => sub { var 'start_time' => Time::HiRes::time(); };
	my $fun = sv_debug('time');
	hook after => sub { my $start = var 'start_time'; &$fun("Request time: ", (Time::HiRes::time() - $start)); };
}


# Avoid the default Dancer's HTML answer

hook on_route_exception => sub {
	my ( $exception ) = @_;
    my $fmt; eval { $fmt = Silvestris::Cyclotis::Format->for_dancer_params(); };
    $fmt = Silvestris::Cyclotis::Format->for_dancer_params(config->{formats}{default} || 'line');
    # only if previous line did work
    halt $fmt->reencode (1, $fmt->produce_error($exception));
};

# Hook for die
hook before_error_render => sub {
    my ( $exception ) = @_;
    my $fmt; eval { $fmt = Silvestris::Cyclotis::Format->for_dancer_params(); };
    $fmt = Silvestris::Cyclotis::Format->for_dancer_params(config->{formats}{default} || 'line');
    # only if previous line did work
    halt $fmt->reencode (1, $fmt->produce_error($exception));
};

any qr{.*} => sub { return Silvestris::Cyclotis::Format->for_dancer_params()->produce_error ("Invalid URI path : " . request->uri); };

dance();

=head1 LICENSE

Copyright 2013 Silvestris Project (L<http://www.silvestris-lab.org/>)

Licensed under the EUPL, Version 1.1 or - as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: L<http://ec.europa.eu/idabc/eupl>

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
