=head1 Package formats::json

Gives answers from web-creator in JSON 

=head1 METHODS

=cut
package formats::json;

use vr;

=head1 formats::json->message ($status, $cause, $where)

Basic message without contents

=cut

sub message {
	my $self = shift;
	my $status = shift || 'OK';
	my $cause = shift; $cause =~ s/[\r\n]//g; $cause = qq(, "cause": "$cause") if $cause;
	my $where = shift; $where = qq(, "perl-location": "$where") if $where;
	my $RES = << "EOF";
{
	"server": "$main::SERVER",
	"response": {
		"status": "$status"
		$cause
		$where
	}
}
EOF
	unless (config->{formats}{indent}) { $RES =~ s/\n//g; $RES =~ s/\s+/ /g; }
	return $RES;
}

=head1 formats::json->envelope ([$status, $cause, $where], $contents)

Message with contents

=cut

sub envelope {
	my $self = shift;
	my $status = shift; my $res = $self->message(@$status);
	$res =~ s!\}\s*$!, !s;
	$res .= shift;
	$res .= "}";
}

=head2 formats::xml->memory (%params)

Gives data about one memory

=cut
sub memory {
	shift; my %spec = @_;
    $spec{mem_name} ||= $spec{table} || $spec{tablename} || $spec{table_name};
	return << "EOF";
	"memory": { 
		"name": "$spec{mem_name}",
		"connection": { "server": "$spec{host}", "port": "$spec{port}", "catalog": "$spec{catalog}", "table": "$spec{table}" }
	}
EOF
}

use Dancer ':syntax';

=head2 formats::json->listMemories (%memories)

Displays data about hash of memories

=cut
sub listMemories {
	shift; my %MEM = @_;
	my $MEMORIES = '"groups": [ ';
	while (my ($key, $tab) = each (%MEM)) {
		my $keyJson = $key; $keyJson =~ s!(\w+)='(\w+)'!\"$1\" : \"$2\", !g or $keyJson = qq("for": "$keyJson"); $keyJson =~ s/,\s*$//;
		$MEMORIES .= "\n\t{ $keyJson, \"memories\": [";
		foreach my $mem (@$tab) {		
			my $info = "";
			$info .= qq("creation-date": "$mem->{creation}", ) if defined $mem->{creation};		# not an optional field, except if not in the table
			while (my ($name, $field) = each (%{config->{list}{fields}})) { $info .= qq("$name": "$mem->{$name}", ) if defined $mem->{$name}; }
			if (ref config->{list}{sql}{view}{fields}{added}) {
    			while (my ($name, $field) = each (%{config->{list}{sql}{view}{fields}{added}})) { 
    				my $val = vr::interpolation($field, $mem);
    				$info .= qq("$name": "$val", ); 
    			}
    		}
			$info =~ s/,\s*$//; $info = qq(, "info": { $info } ) if $info;
			
			$MEMORIES .= << "EOF";
		{
			"name": "$mem->{mem_name}",
			"connection": { "server": "$mem->{host}", "port": "$mem->{port}", "catalog": "$mem->{catalog}", "table": "$mem->{table_schema}.$mem->{table_name}" }
			$info
		},
EOF
		}
		$MEMORIES =~ s/,\s*\r?\n?$//; $MEMORIES .= "\t] }, ";
	}
	$MEMORIES =~ s/,\s*$/\]/; 
	unless (config->{formats}{indent}) { $MEMORIES =~ s/\n//g; $MEMORIES =~ s/\s+/ /g; }
	return $MEMORIES;
}

sub MIME { 'application/json' }

1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
