=head1 Package formats::xml

Gives answers from web-creator in XML 

=head1 METHODS

=cut

package formats::xml;

use vr;

=head2 formats::xml->message ($status, $cause, $where)

Basic message without contents

=cut

sub message {
	my $self = shift;
	my $status = shift || 'OK';
	my $cause = shift; $cause =~ s/[\r\n]//g; $cause = "cause='$cause'" if $cause;
	my $where = shift; $where = "perl-location='$where'" if $where;
	return << "EOF";
<?xml version='1.0' encoding='UTF-8' ?>
<response server='$main::SERVER' status='$status' $cause $where />
EOF
}

=head2 formats::xml->envelope ([$status, $cause, $where], $contents)

Message with contents

=cut

sub envelope {
	my $self = shift;
	my $status = shift; my $res = $self->message(@$status);
	$res =~ s!/>.*!>\n!s;
	$res .= shift;
	$res .= "</response>";
}

=head2 formats::xml->memory (%params)

Gives data about one memory

=cut
sub memory {
	shift; my %spec = @_;
	return << "EOF";
	<memory name='$spec{mem_name}'>
		<connection server='$spec{host}' port='$spec{port}' catalog='$spec{catalog}' table='$spec{table}'  />
	</memory>
EOF
}

use Dancer ':syntax';

=head2 formats::xml->listMemories (%memories)

Displays data about hash of memories

=cut
sub listMemories {
	shift; my %MEM = @_;
	my $MEMORIES = "";
	my $hasFilters = scalar(keys(%MEM)) > 1;
	while (my ($key, $tab) = each (%MEM)) {
		$MEMORIES .= "\t<memories";
		if ($key !~ /=/) {
			if ($hasFilters) { $MEMORIES .= ">\n"; }
     		else { my $key1 = $key; $key1 =~ s/['"]//g; $MEMORIES .= " for='$key1'>\n"; }
        } else {
        	my ($k, $v) = split (/=/, $key);
        	$k  =~ s/['"]//g; $v  =~ s/['"]//g;
        	$MEMORIES .= " $k='$v'>\n";
        }
		foreach my $mem (@$tab) {
			$mem->{mem_name} ||= $mem->{table} || $mem->{tablename} || $mem->{table_name};
			$MEMORIES .= "\t\t<memory name='$mem->{mem_name}'>\n";
			$MEMORIES =~ s/>\n$/ creation-date='$mem->{creation}'>\n/ if defined $mem->{creation};
			while (my ($name, $field) = each (%{config->{list}{fields}})) { $MEMORIES =~ s/>\n$/ $name='$mem->{$name}'>\n/ if defined $mem->{$name}; }
			if (ref config->{list}{sql}{view}{fields}{added}) {
				while (my ($name, $field) = each (%{config->{list}{sql}{view}{fields}{added}})) { 
					$MEMORIES =~ s/>\n$/" $name='" . vr::interpolation($field, $mem) . "'>\n"/e;
				}
			}
			$MEMORIES .= "\t\t\t<connection server='$mem->{host}' port='$mem->{port}' catalog='$mem->{catalog}' table='$mem->{table_schema}.$mem->{table_name}' />\n";
			$MEMORIES .= "\t\t</memory>\n";
		}
		$MEMORIES .= "\t</memories>\n";
	}
	return $MEMORIES;
}

sub MIME { 'text/xml' }

1;

=head1 License

Copyright 2014 Silvestris Project (http://www.silvestris-lab.org/)

Licensed under the EUPL, Version 1.1 or – as soon they will be approved by the European Commission - subsequent versions of the EUPL (the "Licence");
You may not use this work except in compliance with the Licence.
You may obtain a copy of the Licence at: http://ec.europa.eu/idabc/eupl

Unless required by applicable law or agreed to in writing, software distributed under the Licence is distributed on an "AS IS" basis,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the Licence for the specific language governing permissions and limitations under the Licence. 

=cut
