#! /usr/bin/perl

use Dancer;
use Encode;
eval 'require "Time::HiRes";'; # use if possible, do not crash if fails

if (config->{deamon}{'must-start'}) {
    my $pid = fork();
    if (! defined $pid) { die "Cannot start deamon: $!"; }
    elsif ($pid == 0) { 
        my @dirs; push(@dirs,config->{deamon}{$_}) foreach ('import-dir','search-input','search-result');
        print STDERR config->{'ef-binaries'}{location} . "/ef-deamon.pl '" . config->{database} . "' "
           . join(' ', @dirs); 
        exec config->{'ef-binaries'}{location} . "/ef-deamon.pl '" . config->{database} . "' "
           . join(' ', @dirs); 
    }
}

our %conf_params = ( allow_small_search => config->{allow}{small_search}, 'dest_dir' => (config->{deamon}{'search-result'} || config->{dest_dir}) );

our $limitSyncUpload = config->{'limit-sync-upload'} || 10240;
$limitSyncUpload = $1 * 1_024 if $limitSyncUpload =~ /(\d+)\s*[kK]/;
$limitSyncUpload = $1 * 1_048_576 if $limitSyncUpload =~ /(\d+)\s*[mM]/;
sub import {
    my $fileName = shift;
    my $cmd = config->{'ef-binaries'}{location} . "/ef-import.pl "
            . "'" . config->{database} . "' " 
            . $fileName;
    if (! -e $fileName) { return "Error: File does not exist"; }
    elsif ((-s $fileName) > $limitSyncUpload) {
        if (config->{deamon}{'import-dir'}) {
           system 'mv', $fileName => config->{deamon}{'import-dir'};
           return "File sent for import";
        } else {
           my $pid = fork();
           if (! defined $pid) { return "Error with process: $!"; }
           elsif ($pid == 0) { exec $cmd; }
           else { return "Import process started"; }
        }
    } else {
        open(PIPE, "$cmd 2>&1 |");
        my $res = ''; while (<PIPE>) { $res .= $_; }
        close(PIPE); return $res;
    }
}

# -------------------------------------- HTML part ----------------------

get '/' => sub { return template 'home.html', { stats => &stats(), %conf_params } };

post '/upload' => sub {
    my $start = time; my $fileRef = request->upload('file');
    my $res = &import($fileRef->tempname);
    $res = "<font color=red>$res</font>" if $res =~ /^Error/i;
    $start = time - $start;
    return template 'home.html', { command_res => $res . "\n<br>Duration: $start seconds", stats => &stats(), %conf_params };
};

post '/simple-search' => sub {
    my $start = time;
    my $args = param('src'); $args .= ':' . param('tra') if param('tra');
    $args .= " -doc $&" if param('doc') =~ /^.+$/; $args .= "-coll $&" if param('coll') =~ /^.+$/;
    $args .= " -seg '$&'" if param('phrase') =~ /^.+$/;
    open(PIPE, config->{'ef-binaries'}{location} . "/ef-find.pl "
	    . "'" . config->{database} . "' $args  2>&1 |");  
    if (param('fmt') eq 'tmx') {
        header 'Content-Type' => 'text/xml; charset=utf-8';
        local $/ = undef; my $res = <PIPE>; close PIPE; return $res;
    }
	    
    header 'Content-Type' => 'text/html; charset=utf-8';
    my @res = (); my $err = ''; my $count = 0;
    local $/ = '</tu>'; while (<PIPE>) { 
        $err .= $_ and last unless /<tu/; my %row; push(@res,\%row);
        $row{id} = $1 if (/tuid='(.+?)'/);
        $row{doc} = $1 if (m!<prop type='Document name'>(.+?)</prop>!);
        my %tuv; while (m!<tuv xml:lang='(.+?)'(?: author='(.+?)'[^>]*)?>(.+?)</tuv>!gs) {
           my $lg = $1; $tuv{$lg}{author} = $2; 
           my $content = $3; $tuv{$lg}{seg} = $1 if $content =~ m!<seg>(.+)</seg>!m;
        }
        $row{src} = $tuv{param('src')}{seg}; $count++;
        while (my ($lg,$seg) = each(%tuv)) { next if $lg eq param('src'); $row{tra} .= "$lg (${$seg}{author}): ${$seg}{seg} <br/>"; }
    }
    close(PIPE); 
    return template 'search.html', { src_lang => param('src'), search_time => time - $start, error => $err, result => \@res, count => $count };
};

post '/file-search' => sub {
    my $file = request->upload('file')->tempname; $file = substr($file, rindex($file,'/') + 1); $file .= '.tmx'; $file = config->{dest_dir} . '/' . $file;
    if (config->{deamon}{'search-input'} and config->{deamon}{'search-result'}) {
       my $txtFile = request->upload('file')->filename; $txtFile = substr($txtFile, rindex($txtFile,'/') + 1); $txtFile = config->{deamon}{'search-input'} . '/' . $txtFile;
       open(IN, '>', "$txtFile.tmp"); print IN "srcLang: ", param('src'), "\n"; 
       print IN "doc: $&\n" if param('doc') =~ /^.+$/; print IN "collection: $&\n" if param('coll') =~ /^.+$/;
       print IN "\n"; 
       open(TMP, '<', request->upload('file')->tempname); while (<TMP>) { print IN $_; } close(TMP);
       close IN; system 'mv', "$txtFile.tmp" => $txtFile;       
    } else {
        my $args = param('src'); $args .= ':' . param('tra') if param('tra');
        $args .= " -doc $&" if param('doc') =~ /^.+$/; $args .= "-coll $&" if param('coll') =~ /^.+$/;
        $args .= " -file " . request->upload('file')->tempname;
        system config->{'ef-binaries'}{location} . "/ef-find.pl " . "'" . config->{database} . "' $args > $file &"; 
    }

    return template 'home.html', { command_res => "Call OK (find result in $file)",'dest_dir' => config->{dest_dir}  };
};

sub stats {
    if (my $statsDir = config->{deamon}{'search-result'}) {
        if (-e "$statsDir/stats") {
            open(STATS, "$statsDir/stats");
            my %stats;
            while (<STATS>) { $stats{lc($1)} = $2 if /^(\w)\w+.*[:=]\s*(\d+)/; }
            close(STATS); return "<b>$stats{u}</b> translation units in <b>$stats{d}</b> document(s) / <b>$stats{c}</b> collections";
        }
    }
    open(PIPE, config->{'ef-binaries'}{location} . "/ef-stats.pl '" . config->{database} . "' |");
    my %stats;
    while (<PIPE>) { $stats{lc($1)} = $2 if /^(\w)\w+.*[:=]\s*(\d+)/; }
    close(PIPE); return "<b>$stats{u}</b> translation units in <b>$stats{d}</b> document(s) / <b>$stats{c}</b> collections";
}

# -------------------------------------- REST part ----------------------

get '/api/upload' => sub {
    my $start = time;
    my $res = &import(param('file'));
    my $mode = 'sync'; $mode = 'async' if (-s param('file')) > $limitSyncUpload; $mode = 'deamon' if ($mode eq 'async') and (defined config->{deamon}{'import-dir'}); 
    $start = time - $start;
    return qq[{ "result": "$res", "mode": "$mode", "duration": $start }];
};

use File::Temp;

post '/api/upload' => sub {
    my $start = time; 
    my ($fh, $filename) = File::Temp::tempfile(SUFFIX => '.tmx'); print $fh request->body(); close $fh;
    my $res = &import($filename);
    $start = time - $start;
    my $mode = 'sync'; $mode = 'async' if (-s $filename) > $limitSyncUpload; $mode = 'deamon' if ($mode eq 'async') and (defined config->{deamon}{'import-dir'}); 
    return qq[{ "result": "$res", "mode": "$mode", "duration": $start }];
};

post '/api/batch-search' => sub {
    my $mode = 'async'; $mode = 'deamon' if config->{deamon}{'search-input'} and config->{deamon}{'search-result'};
    my $file = undef;
    if (config->{deamon}{'search-input'} and config->{deamon}{'search-result'}) {
       my $txtFile = config->{deamon}{'search-input'} . '/' . File::Temp::tmpnam();
       open(IN, '>', "$txtFile.tmp"); print IN "srcLang: ", param('src'), "\n"; 
       print IN "doc: $&\n" if param('doc') =~ /^.+$/; print IN "collection: $&\n" if param('coll') =~ /^.+$/;
       print IN "\n"; 
       print IN request->body();
       close IN; system 'mv', "$txtFile.tmp" => "$txtFile.txt";           
       $file = substr($txtFile, rindex($txtFile,'/')); $file .= ".tmx"; $file = config->{deamon}{'search-result'} . "/$file";
    } else {
        my ($fh, $filename) = File::Temp::tempfile(SUFFIX => '.txt'); print $fh request->body(); close $fh;
        my $args = param('src'); $args .= ':' . param('tra') if param('tra');
        $args .= " -doc $&" if param('doc') and param('doc') =~ /^.+$/; $args .= "-coll $&" if param('coll') and param('coll') =~ /^.+$/;
        $args .= " -file " . $filename;   
        $file = $filename; $file =~ s!^.+/!!; $file = config->{dest_dir} . "/result-$file.tmx";
        system config->{'ef-binaries'}{location} . "/ef-find.pl " . "'" . config->{database} . "' $args > $file &"; 
    }
    return qq[{ "result": "Call OK", "mode": "$mode", "dest-file": "$file" }];
};

dance;
