/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.maligna.comparator;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.maligna.coretypes.Alignment;

public class Diff {
    private List<Alignment> commonList;
    private List<List<Alignment>> leftGroupList;
    private List<List<Alignment>> rightGroupList;
    private List<Alignment> leftList;
    private List<Alignment> rightList;

    public Diff(List<Alignment> commonList, List<List<Alignment>> leftGroupList, List<List<Alignment>> rightGroupList) {
        if (leftGroupList.size() != rightGroupList.size()) {
            throw new IllegalArgumentException("Left and right list lengths must be equal.");
        }
        this.commonList = commonList;
        this.leftGroupList = leftGroupList;
        this.rightGroupList = rightGroupList;
        this.leftList = this.mergeGroups(leftGroupList);
        this.rightList = this.mergeGroups(rightGroupList);
    }

    private List<Alignment> mergeGroups(List<List<Alignment>> groupList) {
        ArrayList<Alignment> list = new ArrayList<Alignment>();
        for (List<Alignment> alignmentList : groupList) {
            list.addAll(alignmentList);
        }
        return list;
    }

    public List<Alignment> getCommonList() {
        return this.commonList;
    }

    public List<List<Alignment>> getLeftGroupList() {
        return this.leftGroupList;
    }

    public List<List<Alignment>> getRightGroupList() {
        return this.rightGroupList;
    }

    public List<Alignment> getLeftList() {
        return this.leftList;
    }

    public List<Alignment> getRightList() {
        return this.rightList;
    }
}

