/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.channel;

import com.trilead.ssh2.channel.Channel;
import java.io.IOException;
import java.io.InputStream;

public final class ChannelInputStream
extends InputStream {
    Channel c;
    boolean isClosed = false;
    boolean isEOF = false;
    boolean extendedFlag = false;

    ChannelInputStream(Channel c, boolean isExtended) {
        this.c = c;
        this.extendedFlag = isExtended;
    }

    public int available() throws IOException {
        if (this.isEOF) {
            return 0;
        }
        int avail = this.c.cm.getAvailable(this.c, this.extendedFlag);
        return avail > 0 ? avail : 0;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length || off + len < 0 || off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.isEOF) {
            return -1;
        }
        int ret = this.c.cm.getChannelData(this.c, this.extendedFlag, b, off, len);
        if (ret == -1) {
            this.isEOF = true;
        }
        return ret;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int ret = this.read(b, 0, 1);
        if (ret != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }
}

